<?php
class RequestConfirmMail extends SGL_Observer
{
    function update($observable)
    {
        //  send email confirmation according to config
        $observable->oUser->hash_key = $observable->input->hash_key;
        $this->conf = $observable->conf;

        if ($this->conf['RegisterMgr']['sendEmailConfUser']) {
            $bEmailSent = $this->_sendEmail($observable->oUser, $observable->input->moduleName);
            
            if (!$bEmailSent || $bEmailSent == '') {
                return SGL::raiseError('Problem sending email', SGL_ERROR_EMAILFAILURE);
            }
        }
    }
    
    function _sendEmail($oUser, $moduleName)
    {
        require_once SGL_CORE_DIR . '/Emailer.php';
        $userActivate = $this->getUserActivate($oUser);
        $confirmActivate = isset($this->conf['RegisterMgr']['allowActivateEmail']) ? $this->conf['RegisterMgr']['allowActivateEmail'] : '';
        
        if ($confirmActivate != '') {
            // confirm activate = yes

            if (isset($userActivate) && $userActivate != '') {
                //send activate hash_key = yes
                $oUser->email_template_user = 'email_activateEmail_user.php';
                $oUser->email_template_admin = 'email_activateEmail_admin.php';
                
                $oUser->date_expired =  $this->getExpiredDate($oUser,$moduleName);
                $oUser->hash_key = $oUser->hash_key;
                $oUser->siteUrl = $this->conf['site']['baseUrl'] . '/' . $this->conf['site']['frontScriptName'] . '/user/activateemail/emailKey/' . $oUser->email . '/hashKey/' . $oUser->hash_key;
                $oUser->activationUrl = $this->conf['site']['baseUrl'] . '/' . $this->conf['site']['frontScriptName'] . '/user/action/requestChangeUserStatus/frmUserID/' . $oUser->usr_id;
                
                if ($this->conf['RegisterMgr']['sendEmailConfUser']) {
                    $oUser->subject = 'Thanks for registering at ' . $this->conf['site']['name'];
                    $send = $this->sendEmailConfUser($oUser,$moduleName);
                }
                
                if ($this->conf['RegisterMgr']['sendEmailConfAdmin']) {
                    $oUser->subject = 'New Registration at ' . $this->conf['site']['name'];
                    $send = $this->sendEmailConfAdmin($oUser,$moduleName);
               }
            } else {
                // no send activate
                $autoEnable = isset($this->conf['ActivateEmailMgr']['autoEnable']) ? $this->conf['ActivateEmailMgr']['autoEnable'] : '';
                $oUser->activationUrl = $this->conf['site']['baseUrl'] . '/' . $this->conf['site']['frontScriptName'] . '/user/action/requestChangeUserStatus/frmUserID/' . $oUser->usr_id;
                
                if ($autoEnable) {
                    $oUser->activationUrl = '';
                    $oUser->email_template_user = 'email_registration_thanks.php';
                    $oUser->email_template_admin = 'email_registration_admin.php';
                } else {
                    $oUser->email_template_user = 'email_registration_thanks_waiting_for_approval.php';
                    $oUser->email_template_admin = 'email_registration_waiting_for_approval.php';
                }

                $oUser->hash_key = "";
                $oUser->date_expired = "";
                $oUser->siteUrl = $this->conf['site']['baseUrl'] . '/' . $this->conf['site']['frontScriptName'] . '/user/login';
                
                if ($this->conf['ActivateEmailMgr']['sendEmailConfUser']) {
                    $oUser->subject = 'Thanks for registering at ' . $this->conf['site']['name'];
                    $send = $this->sendEmailConfUser($oUser,$moduleName);
                }
                
                if ($this->conf['ActivateEmailMgr']['sendEmailConfAdmin']) {
                    $oUser->subject = 'New Registration at ' . $this->conf['site']['name'];
                    $send = $this->sendEmailConfAdmin($oUser,$moduleName);
               }
            }
            
            //  check error stack
            return (SGL_Error::count()) ? false : true;
            //return true;
        } else {
            return true;
        }
    }
    
    function getExpiredDate(&$oUser,$moduleName)
    {   
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        $dateCreated = $oUser->date_created;
        $trialDay = $this->conf['ActivateEmailMgr']['expiry_day'];
        // ˹ѹ expired  default  15 ѹ
        if (trim($trialDay) == "") $trialDay = 15;
        //get Create Date timestamp
            $timestampCreate = strtotime($dateCreated);
        //get Expired Date timestamp
            $timestampExpired = $timestampCreate + (($trialDay) *  86400); //90000); // 
        // Transform Date Time Format
            $expiredDate = date("Y-m-d G:i:s" , $timestampExpired);
        return $expiredDate ;                   
    }
    
    function getUserActivate(&$oUser)
    {
        $this->dbh = & SGL_DB::singleton();
        $queryHash = "
                        SELECT
                                    ctime
                        FROM
                                    {$this->conf['table']['user_hash']}
                        WHERE
                                    usr_id = '{$oUser->usr_id}'
                        ";
        $oUserHash = $this->dbh->getRow($queryHash);

        if (isset($oUserHash->ctime) && $oUserHash->ctime) {
            return $oUserHash->ctime;
        }
    }
    
    function sendEmailConfUser(&$oUser,$moduleName)
    {
        $realName = $oUser->first_name . ' ' . $oUser->last_name;
        $recipientName = (trim($realName)) ? $realName : '&lt;no name supplied&gt;';
        $options = array(
                'toEmail'       => $oUser->email,
                'toRealName'    => $recipientName,
                'fromEmail'     => $this->conf['email']['admin'],
                'replyTo'       => $this->conf['email']['admin'],
                'template'  => SGL_THEME_DIR . '/' . $_SESSION['aPrefs']['theme'] . '/' .
                    $moduleName . '/' . $oUser->email_template_user,
                'username'      => $oUser->username,
                'password'      => $oUser->passwdClear,
                'userAddress1' => $oUser->addr_1,
                'userAddress2' => $oUser->addr_2,
                'userAddress3' => $oUser->addr_3,
                'userCity' => $oUser->city,
                'userState' => $oUser->region,
                'userZipCode' => $oUser->post_code,
                'userCountry' => $oUser->country,        
                'userPhone' => $oUser->telephone,  
                'userMobile' => $oUser->mobile,              
                'expiredDate' => $oUser->date_expired,              
                'expiredDays' => $this->conf['ActivateEmailMgr']['expiry_day'],
                'siteUrl'       =>  $oUser->siteUrl,
                'siteName' => $this->conf['site']['name'],
                'hash_key' => $oUser->hash_key,
                'subject'       => $oUser->subject,
        );
        $message = & new SGL_Emailer($options);
        $message->prepare();
        $message->send();
        
    }
    
    function sendEmailConfAdmin(&$oUser,$moduleName)
    {
        $realName = $oUser->first_name . ' ' . $oUser->last_name;
        $recipientName = (trim($realName)) ? $realName : '&lt;no name supplied&gt;';
        $options = array(
                'toEmail'       => $this->conf['email']['admin'],
                'toRealName'    => $recipientName,
                'fromEmail'     => $this->conf['email']['admin'],
                'replyTo'       => $this->conf['email']['admin'],
                'template'  => SGL_THEME_DIR . '/' . $_SESSION['aPrefs']['theme'] . '/' .
                    $moduleName . '/' . $oUser->email_template_admin,
                'username'      => $oUser->username,   
                'userAddress1' => $oUser->addr_1,
                'userAddress2' => $oUser->addr_2,
                'userAddress3' => $oUser->addr_3,
                'userCity' => $oUser->city,
                'userState' => $oUser->region,
                'userZipCode' => $oUser->post_code,
                'userCountry' => $oUser->country,        
                'userPhone' => $oUser->telephone,  
                'userMobile' => $oUser->mobile,              
                'expiredDate' => $oUser->date_expired,
                'expiredDays' =>$this->conf['ActivateEmailMgr']['expiry_day'],                                         
                'siteUrl'        => $this->conf['site']['baseUrl'] .  '/' . $this->conf['site']['frontScriptName'] . '/user',
                'subject'       => $oUser->subject,
                'activationUrl' => $oUser->activationUrl,
        );
        $notification = & new SGL_Emailer($options);
        $notification->prepare();
        $notification->send();
    }
}
?>