<?php
class SendToMailMan extends SGL_Observer
{
    function update($observable)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->conf = $observable->conf;

        if (is_dir(SGL_MOD_DIR . "/mailmanweb")) {
            $checkSetUp = $this->_getSetUpModule();
        } else {
            $checkSetUp = '';
        }
        
        if (isset($checkSetUp) && $checkSetUp != '') {
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ///////////////////////////////////////////////// update ///////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            if (isset($observable->oUser->actionSend) && $observable->oUser->actionSend == 'update') {
                $checkSubscribe = isset($observable->oUser->checkSubscribe) ? $observable->oUser->checkSubscribe : '';
                $oUser = $observable->oUser;
                if ($checkSubscribe == '1') {
                    $send = $this->_sendEmailToSubscribe($oUser);
                } else {
                    $send = $this->_sendEmailToUnSubscribe($oUser);
                }
                
                $addText =  $this->subscribeText($oUser->email, $checkSubscribe);
                return true;
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ///////////////////////////////////////////////// delete ///////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            } elseif (isset($observable->input->action) && $observable->input->action == 'delete') {
                $delete = $this->_deleteUser($observable);
                return $true = '1';
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ///////////////////////////////////////////////// add //////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            } elseif (isset($observable->input->action) && $observable->input->action == 'add') {
                $add = $this->_addUserSubscribe($observable);
                return $true = '1';
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ///////////////////////////////////////// changeUserStatus //////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            } elseif (isset($observable->input->action) && $observable->input->action == 'changeUserStatus') {
                
                $changeUserStatus = $this->_getUserData($observable->oUser);
                $observable->oUser = $changeUserStatus;

                if ($observable->oUser->is_acct_active == '1') {
                    $send = $this->_sendEmailToSubscribe($observable->oUser);
                } else {
                    $send = $this->_sendEmailToUnSubscribe($observable->oUser);
                }
                
                $addText =  $this->subscribeText($observable->oUser->email, $observable->oUser->is_acct_active);
                return true;
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ////////////////////////////////////////////// activate ////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            } elseif (isset($observable->input->action) && $observable->input->action == 'activate') {
                $hashKey = isset($observable->oUser->hash_key) ? $observable->oUser->hash_key : '';
                $true = '1';
                $eMail = $observable->oUser->email;
                
                if (!$hashKey) {
                    $send = $this->_sendEmailToSubscribe($observable->oUser);
                    $addText =  $this->subscribeText($eMail, $true);
                    
                } else {
                    return $true;
                }
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ////////////////////////////////////////////// insert ///////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            } elseif (isset($observable->input->action) && $observable->input->action == 'insert') {
                $hashKey = isset($observable->oUser->hash_key) ? $observable->oUser->hash_key : '';
    
                if ($observable->conf['RegisterMgr']['allowActivateEmail'] == '1') {
                    if ($hashKey) {
                        return $true = '1';
                    } else {
                        $true = '1';
                        $eMail = $observable->oUser->email;
                        
                        $addSub =  $this->_addUserSubscribe($observable->oUser);
                        $addText = $this->subscribeText($eMail, $true);
                        return $true;
                    }
                } else {
                    $true = '1';
                    $eMail = $observable->oUser->email;
                    
                    $addSub =  $this->_addUserSubscribe($observable->oUser);
                    $addText =  $this->subscribeText($eMail, $true);
                    return $true;
                }
                
                /////////////////////////////////////////////////////////////////////////////////////////////////
                ////////////////////////////////////////////// else  ////////////////////////////////////////////
                /////////////////////////////////////////////////////////////////////////////////////////////////
            } else {
                return true;
            }
        }
        return true;
    }
    
    function _getUserData(&$oUserUnsubscribe)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->dbh = & SGL_DB::singleton();
        $query = "SELECT *
                        FROM {$this->conf['table']['user']} 
                        WHERE `usr_id` = '{$oUserUnsubscribe->usr_id}'
                        ";
        
        $oUserUnsubscribe = $this->dbh->getAll($query);
        return isset($oUserUnsubscribe[0]) ? $oUserUnsubscribe[0] : '';
    }
    
    function _getSetUpModule($moduleName = 'mailmanweb')
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->dbh = & SGL_DB::singleton();
        $query = "SELECT `module_id`
                        FROM {$this->conf['table']['module']} 
                        WHERE `name` = '{$moduleName}'
                        ";
        
        $oSetupModule = $this->dbh->getOne($query);
        return isset($oSetupModule) ? $oSetupModule : '';
    }

    /*
    function _getHashKey(&$oUser)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->dbh = & SGL_DB::singleton();
        $queryHash = "
                        SELECT`ctime`
                        FROM {$this->conf['table']['user_hash']}
                        WHERE `usr_id` = '{$oUser->usr_id}'
                        ";
        
        $oUserHash = $this->dbh->getOne($queryHash);
        return isset($oUserHash) ? $oUserHash : '';
    }
    */

    function _sendEmailToSubscribe(&$oUser, $module = 'user')
    {
        require_once SGL_CORE_DIR . '/Emailer.php';
        #################### Create Data ###################
        $oUser->email_template_active = 'email_sendToMailMan_active.php';
        $oUser->subject = 'send Subscribe Mail';
        $oUser->statusSend = 'Subscribe Email :' . $oUser->email;
        
        $realName = $oUser->first_name . ' ' . $oUser->last_name;
        $recipientName = (trim($realName)) ? $realName : '&lt;no name supplied&gt;';
        ###############################################[]
        $options = array(
                'toEmail'       => $this->conf['AdminSubscribeWebMgr']['MemberJoinMail'],//ผู้รับ
                'sendMail' => $oUser->statusSend,
                'toRealName'    => $recipientName,
                'fromEmail'     => $oUser->email,//ผู้ส่ง
//             'fromEmail'     => $this->conf['email']['admin'],//form
//             'replyTo'       => $this->conf['email']['admin'],
                'template'  => SGL_MOD_DIR . '/' . $module . '/templates/' . $oUser->email_template_active,
                'subject'       => $oUser->subject,
        );

        $message = & new SGL_Emailer($options);
        $message->prepare();
        $message->send();
        return true;
    }
    
    function _sendEmailToUnSubscribe(&$oUser, $module = 'user')
    {
        require_once SGL_CORE_DIR . '/Emailer.php';
        #################### Create Data ###################
        $oUser->email_template_active = 'email_sendToMailMan_active.php';
        $oUser->subject = 'send Un-Subscribe Mail';
        $oUser->statusSend = 'Un-Subscribe Email :' . $oUser->email;
        
        $realName = $oUser->first_name . ' ' . $oUser->last_name;
        $recipientName = (trim($realName)) ? $realName : '&lt;no name supplied&gt;';
        ###############################################
        $options = array(
                'toEmail'       => $this->conf['AdminSubscribeWebMgr']['MemberLeaveMail'],
                'sendMail' => $oUser->statusSend,
                'toRealName'    => $recipientName,
                'fromEmail'     => $oUser->email,
//                'fromEmail'     => $this->conf['email']['admin'],
//                'replyTo'       => $this->conf['email']['admin'],
                'template'  => SGL_MOD_DIR . '/' . $module . '/templates/' . $oUser->email_template_active,
                'subject'       => $oUser->subject,
        );

        $message = & new SGL_Emailer($options);
        $message->prepare();
        $message->send();
        return true;
    }
    
    function _deleteUser(&$observable)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (isset($observable->input->AdminMailManWebMgr) && $observable->input->AdminMailManWebMgr == '1') {
            $observable->input->aEmailDelete = $observable->input->frmDelete;
        }
        
        foreach ($observable->input->aEmailDelete as $val) {
            $eMail = $val;
            $oUser->email = $val;
            $oUser->first_name = '';
            $oUser->last_name = '';
            $subscribe = '0';
            
            $delete = $this->subscribeText($eMail, $subscribe);
            $send = $this->_sendEmailToUnSubscribe($oUser);
        }
    }
    
    function _addUserSubscribe(&$observable)
    {
        if (isset($observable->email) && $observable->email != '') {
            $eMail = $observable->email;
        } else {
            $eMail = $observable->input->eMail;
        }

        $oUser->email = $eMail;
        $oUser->first_name = '';
        $oUser->last_name = '';
       
       $send = $this->_sendEmailToSubscribe($oUser);
       return $send;
    }
    
    function subscribeText(&$eMail, &$subscribe)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        ########################################
        $input->pathMailManList = SGL_VAR_DIR . '/' . $this->conf['AdminSubscribeWebMgr']['pathMailManList'];
        ################ Start Subscribe #############
        // ---------------------------- ตั้งค่าพื้นฐาน --------------------------
        $eMail = isset($eMail) ? $eMail : '';
        $subscribe = isset($subscribe) ? $subscribe : '';
        $filename = $input->pathMailManList;

        // -------------------- เอาออกก่อนเขียนใหม่ ----------------
        $healthy = trim($eMail);
        $resData = '';
        $aData = file($filename);
        // -------------------------------------------------------------
        $tp = fopen($filename, 'w+');
        
        for($i=0;$i<sizeof($aData);$i++) {
            $newphrase[$i] = str_replace(trim($healthy),"", trim($aData[$i]));
            if (trim($newphrase[$i]) != "") {
                $resData .= $newphrase[$i] . "\n";
            }
        }
        
        fwrite($tp, $resData);
        fclose($tp);
        
        if ($subscribe == '1') {
            // --------------------- เขียนลงไปใหม่ -----------------------
            $resDataAdd = '';
            $fromto = trim($eMail);
            $aData = file($filename);
            // -------------------------------------------------------------
            $aDataAdd = file($filename);
            $tp = fopen($filename, 'w+');
            
            for($i=0;$i<sizeof($aDataAdd);$i++){
                $resDataAdd .= $aDataAdd[$i];
            }

            $contents =  $fromto ."\n";
            $contents .= $resDataAdd ;
            fwrite($tp, $contents);
            fclose($tp);

            // --------------------- จบการเขียนเพิ่ม -------------------
        }
        SGL::raiseMsg('Set Unsubscribe Mail successfully updated', true, SGL_MESSAGE_INFO);
    }
}
?>