<?php
 require_once SGL_CORE_DIR . '/UrlParser/SefStrategy.php'; class SGL_URL { var $url; var $protocol; var $username; var $password; var $host; var $port; var $path; var $querystring; var $aQueryData; var $frontScriptName; var $aStrategies = array(); var $aRes = array(); var $anchor; var $useBrackets; function SGL_URL( $url = null, $useBrackets = true, $parserStrategy = null, $conf = null) { $this->__construct($url, $useBrackets, $parserStrategy, $conf); } function __construct($url = null, $useBrackets = true, $parserStrategy = null) { $this->useBrackets = $useBrackets; $this->url = $url; $this->user = ''; $this->pass = ''; $this->host = ''; $this->port = 80; $this->path = ''; $this->aQueryData = array(); $this->anchor = ''; if (is_null($parserStrategy)) { $this->aStrategies[] = new SGL_UrlParser_SefStrategy(); } if (!is_array($parserStrategy) && is_a($parserStrategy, 'SGL_UrlParserStrategy')) { $this->aStrategies[] = $parserStrategy; } elseif (is_array($parserStrategy)) { $this->aStrategies = $parserStrategy; } else { SGL::raiseError('unrecognised url strategy'); } $this->frontScriptName = SGL_Config::get('site.frontScriptName'); } function init() { if (!preg_match('/^[a-z0-9]+:\/\//i', $this->url)) { if (is_a($this->aStrategies[0], 'SGL_UrlParser_SimpleStrategy')) { $this->aQueryData = $this->parseQueryString(); return; } $this->protocol = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' ? 'https' : 'http'; if (!empty($_SERVER['HTTP_HOST']) && preg_match('/^(.*)(:([0-9]+))?$/U', $_SERVER['HTTP_HOST'], $matches)) { $host = $matches[1]; if (!empty($matches[3])) { $port = $matches[3]; } else { $port = $this->getStandardPort($this->protocol); } } $this->user = ''; $this->pass = ''; $this->host = !empty($host) ? $host : (isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : 'localhost'); $this->port = !empty($port) ? $port : (isset($_SERVER['SERVER_PORT']) ? $_SERVER['SERVER_PORT'] : $this->getStandardPort($this->protocol)); $this->path = !empty($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF'] : '/'; } if (!is_null($this->url)) { $target = (preg_match('/^[a-z0-9]+:\/\//i', $this->url)) ? $this->url : $this->toString(); $urlinfo = parse_url($target); if (preg_match("/\?/", $this->frontScriptName)) { $urlinfo['path'] = preg_replace("/index.php/", "index.php?", $urlinfo['path']); } $this->aQueryData = array(); foreach ($urlinfo as $key => $value) { switch ($key) { case 'scheme': $this->protocol = $value; $this->port = $this->getStandardPort($value); break; case 'user': case 'pass': case 'host': case 'port': $this->$key = $value; break; case 'path': if (isset($value{0}) && $value{0} == '/') { if ($this->frontScriptName != false) { $frontScriptStartIndex = strpos($value, $this->frontScriptName); $frontScriptEndIndex = $frontScriptStartIndex + strlen($this->frontScriptName); if (!$frontScriptStartIndex) { $this->path = $urlinfo['path']; $this->querystring = @$urlinfo['query']; } else { $this->path = substr($value, 0, $frontScriptStartIndex); $this->querystring = substr($value, $frontScriptEndIndex); } } else { $this->path = dirname($_SERVER['SCRIPT_NAME']) == DIRECTORY_SEPARATOR ? '' : dirname($_SERVER['SCRIPT_NAME']); $this->querystring = str_replace($this->path, '', $urlinfo['path']); } } else { $path = dirname($this->path) == DIRECTORY_SEPARATOR ? '' : dirname($this->path); $this->path = sprintf('%s/%s', $path, $value); } break; case 'query': if (isset($urlinfo['query']) && empty($this->querystring)) { $this->querystring = $urlinfo['query']; } $ret = $this->parseQueryString(); if (PEAR::isError($ret)) { return $ret; } else { $this->aQueryData = $ret; } $this->querystring = $this->getModuleName() .'/'. $this->getManagerName() .'/'. SGL_Array::implodeWithKeys('/', $this->getQueryData(true)); break; case 'fragment': $this->anchor = $value; break; } } if (!array_key_exists('query', $urlinfo)) { $ret = $this->parseQueryString(); if (PEAR::isError($ret)) { return $ret; } else { $this->aQueryData = $ret; } } $this->removeStrategies(); return true; } return SGL::raiseError('no URI data', SGL_ERROR_NODATA); } function &singleton() { static $instance; if (!isset($instance)) { $parserStrategy = SGL_Config::get('site.outputUrlHandler'); $class = __CLASS__; $instance = new $class(null, true, new $parserStrategy()); } return $instance; } function getManagerName() { return @$this->aQueryData['managerName']; } function getModuleName() { return @$this->aQueryData['moduleName']; } function getQueryData($strict = false) { $aRet = $this->aQueryData; if (PEAR::isError($aRet)) { return $aRet; } if ($strict) { if (isset($aRet['moduleName'])) { unset($aRet['moduleName']); } if (isset($aRet['managerName'])) { unset($aRet['managerName']); } } $aZendDebugParams = array('debug_fastfile', 'debug_host', 'debug_new_session', 'debug_no_cache', 'debug_port', 'debug_stop', 'debug_url', 'send_sess_end', 'start_debug'); foreach ($aZendDebugParams as $param) { if (isset($aRet[$param])) { unset($aRet[$param]); } } foreach ($aRet as $k => $v) { if (stristr($k, '?start_debug')) { unset($aRet[$k]); } } return $aRet; } function getQueryString() { return $this->querystring; } function parseQueryString() { foreach ($this->aStrategies as $strategy) { $res = $strategy->parseQueryString($this); if (PEAR::isError($res)) { return $res; } else { $this->aRes[] = $res; } } if (SGL_Config::get('site.outputUrlHandler') && SGL_Config::get('site.outputUrlHandler') == 'SGL_UrlParser_ClassicStrategy') { $tmp = array_reverse($this->aRes); $this->aRes = $tmp; } $ret = call_user_func_array('array_merge', $this->aRes); return $ret; } function querystringArrayToHash($aUriParts, $aParsedUri = array()) { $numParts = count($aUriParts); if ($numParts % 2) { array_push($aUriParts, null); ++ $numParts; } $aQsParams = array(); for ($i = 0; $i < $numParts; $i += 2) { $varName = urldecode($aUriParts[$i]); $varValue = urldecode($aUriParts[$i+1]); if ((strpos($varName, '[') !== false) && (strpos($varName, ']') !== false)) { preg_match('/([^\[]*)\[([^\]]*)\]/', $varName, $matches); $aRequestVars = array_merge($_REQUEST, $aParsedUri); if ( !array_key_exists($matches[1], $aRequestVars) && !array_key_exists($matches[1], $aQsParams)) { $aQsParams[$matches[1]] = array(); } if (empty($matches[2])) { array_push($aQsParams[$matches[1]], $varValue); } else { $aQsParams[$matches[1]][$matches[2]] = $varValue; } } else { $aQsParams[$varName] = $varValue; } } return $aQsParams; } function getStrategiesFingerprint($aStrats) { $aStratNames = array(); foreach ($aStrats as $strategy) { $aStratNames[] = get_class($strategy); } $fingerprint = implode('', $aStratNames); return $fingerprint; } function toString() { $retUrl = $this->protocol . '://' . $this->user . (!empty($this->pass) ? ':' : '') . $this->pass . (!empty($this->user) ? '@' : '') . $this->getHostName() . ($this->port == $this->getStandardPort($this->protocol) ? '' : ':' . $this->port) . $this->getPath(); if ($this->frontScriptName != false) { if (!preg_match("/$this->frontScriptName/", $retUrl)) { $retUrl .= $this->getFrontScriptName(); } } $qs = $this->getQueryString(); $qs .= !empty($this->anchor) ? '#' . $this->anchor : ''; if (!empty($qs) && $qs{0} != '/' && substr($retUrl, -1) != '/') { $qs = '/' . $qs . (!empty($this->anchor) ? '#' . $this->anchor : ''); } $retUrl .= $qs; return $retUrl; } function makeLink($action = '', $mgr = '', $mod = '', $aList = array(), $params = '', $idx = 0, $output = '') { $url = & SGL_Url::singleton(); return $url->aStrategies[0]->makeLink( $action, $mgr, $mod, $aList, $params, $idx, $output); } function getStandardPort($scheme) { switch (strtolower($scheme)) { case 'http': return 80; case 'https': return 443; case 'ftp': return 21; case 'imap': return 143; case 'imaps': return 993; case 'pop3': return 110; case 'pop3s': return 995; default: return null; } } function setProtocol($protocol, $port = null) { $this->protocol = $protocol; $this->port = is_null($port) ? $this->getStandardPort() : $port; } function resolveServerVars() { if (!is_file(SGL_VAR_DIR . '/INSTALL_COMPLETE.php')) { return; } if (!empty($_SERVER['PHP_SELF']) && !empty($_SERVER['REQUEST_URI'])) { if (strpos(php_sapi_name(), 'cgi') !== false) { $_SERVER['PHP_SELF'] = $_SERVER['REQUEST_URI']; } elseif ((strlen($_SERVER['REQUEST_URI']) > strlen($_SERVER['PHP_SELF']) && strstr($_SERVER['REQUEST_URI'], '?') && ! SGL_Config::get('site.setup'))) { $_SERVER['PHP_SELF'] = $_SERVER['REQUEST_URI']; } elseif (!SGL_Config::get('site.frontScriptName')) { $_SERVER['PHP_SELF'] = $_SERVER['REQUEST_URI']; } else { } } else { $frontScriptName = SGL_Config::get('site.frontScriptName') ? SGL_Config::get('site.frontScriptName') : 'index.php'; if (substr($_SERVER['SCRIPT_NAME'], -1, 1) != substr($frontScriptName, -1, 1)) { $_SERVER['PHP_SELF'] = $_SERVER['SCRIPT_NAME'] . '?' . @$_SERVER['QUERY_STRING']; } else { $_SERVER['PHP_SELF'] = $_SERVER['SCRIPT_NAME'] . @$_SERVER['QUERY_STRING']; } } } function getHostName() { return $this->host; } function getPath() { return $this->path; } function getFrontScriptName() { return $this->frontScriptName; } function toAbsolute(&$url) { $aUrl = parse_url($url); if (!(isset($aUrl['scheme']))) { $url = SGL_BASE_URL . '/' . $url; } } function getBase() { $aParts = explode('/', $this->path); if (in_array('setup.php', $aParts) || in_array('rvssetup.php', $aParts)) { array_pop($aParts); $this->path = implode('/', $aParts); } $retUrl = $this->protocol . '://' . $this->user . (!empty($this->pass) ? ':' : '') . $this->pass . (!empty($this->user) ? '@' : '') . $this->host . ($this->port == $this->getStandardPort($this->protocol) ? '' : ':' . $this->port) . $this->path; if (preg_match('/~/', $retUrl)) { $retUrl = str_replace('~', '%7E', $retUrl); } if (substr($retUrl, -1) == '/') { $retUrl = substr($retUrl, 0, -1); } return $retUrl; } function parseResourceUri($str) { $ret = array(); $default = array( 'module' => 'default', 'manager' => 'default'); if (empty($str)) { return $default; } $parts = array_filter(explode('/', $str), 'strlen'); $numElems = count($parts); if ($numElems < 2) { return $default; } $ret['module'] = $parts[0]; $ret['manager'] = $parts[1]; $actionExists = (isset($parts[2]) && $parts[2] == 'action') ? true : false; $ret['actionMapping'] = ($actionExists) ? $parts[3] : null; $idx = ($actionExists) ? 4 : 2; if ($numElems <= $idx) { return $ret; } $aTmp = array(); for ($x = $idx; $x < $numElems; $x++) { if ($x % 2) { $aTmp['varValue'] = urldecode($parts[$x]); } else { $aTmp['varName'] = urldecode($parts[$x]); } if (count($aTmp) == 2) { $ret['parsed_params'][$aTmp['varName']] = $aTmp['varValue']; $aTmp = array(); } } return $ret; } function addSessionInfo(&$url) { if (SGL_Config::get('session.allowedInUri')) { $sessionInfo = defined('SID') ? SID : ''; if (!empty($sessionInfo)) { $glue = (preg_match("/\?pageID/i", $url)) ? '&amp;' : '?'; $url .= $glue . $sessionInfo . '&amp;/1/'; } } } function removeSessionInfo(&$aUrl) { $key = array_search(SGL_Config::get('cookie.name'), $aUrl); if ($key !== false) { unset($aUrl[$key], $aUrl[$key + 1]); } } function removeStrategies() { unset($this->aStrategies); } function toPartialArray($url, $frontScriptName) { $aUriParts = explode('/', trim($url, '/')); if ($frontScriptName) { foreach ($aUriParts as $elem) { if ($elem != $frontScriptName) { array_shift($aUriParts); } else { break; } } } else { $aParts = @parse_url($url); if ($aParts && count($aParts)) { $pathFromServer = $aParts['path']; if (!empty($pathFromServer)) { $a_ = explode('/', $pathFromServer); $aUriParts = SGL_Array::removeBlanks($a_); } } else { $aUriParts = array(); } } return $aUriParts; } } class SGL_UrlParserStrategy { function parseQueryString() {} function makeLink($action, $mgr, $mod, $aList, $params, $idx, $output) {} } ?>
<?php
 class SGL_HTTP { function redirect($url = '') { $c = &SGL_Config::singleton(); $conf = $c->getAll(); if (is_scalar($url) && strlen($url)) { if (substr($url, -1) != '/') { $url .= '/'; } if (is_callable(array($conf['site']['outputUrlHandler'], 'makeLinkFromString'))) { $outputUrlHandler = new $conf['site']['outputUrlHandler']; $url = $outputUrlHandler->makeLinkFromString($url); } } else { $req = & SGL_Request::singleton(); if (is_scalar($url)) { $url = array(); } $moduleName = (array_key_exists('moduleName', $url)) ? $url['moduleName'] : $req->get('moduleName'); $managerName = (array_key_exists('managerName', $url)) ? $url['managerName'] : $req->get('managerName'); $aParams = array(); foreach ($url as $k => $v) { if ($k == 'moduleName' || $k == 'managerName') { continue; } if (is_string($k)) { $aParams[] = urlencode($k).'/'.urlencode($v); } } $qs = (count($aParams)) ? implode('/', $aParams): ''; $url = ($conf['site']['frontScriptName']) ? $conf['site']['frontScriptName'] . '/' . $moduleName : $moduleName; if (!empty($managerName)) { $url .= '/' . $managerName; } $url .= '/' . $qs; if (is_callable(array($conf['site']['outputUrlHandler'], 'makeLinkFromString'))) { $outputUrlHandler = new $conf['site']['outputUrlHandler']; $url = $outputUrlHandler->makeLinkFromString($url); } SGL_Url::toAbsolute($url); if (substr($url, -1) != '/') { $url .= '/'; } SGL_Url::addSessionInfo($url); } header('Location: ' . $url); exit; } } ?>
<?php
 class SGL_Manager { var $masterTemplate = 'master.html'; var $template = ''; var $pageTitle = 'default'; var $validated = false; var $sortBy = ''; var $_aActionsMapping = array(); var $conf = array(); var $dbh = null; function SGL_Manager() { SGL::logMessage(null, PEAR_LOG_DEBUG); $c = &SGL_Config::singleton(); $this->conf = $c->getAll(); $this->dbh = $this->_getDb(); if ($this->conf['translation']['container'] == 'db') { $this->trans = & SGL_Translation::singleton(); } if (!empty($this->conf['site']['masterTemplate'])) { $this->masterTemplate = $this->conf['site']['masterTemplate']; } } function &_getDb() { $locator = &SGL_ServiceLocator::singleton(); $dbh = $locator->get('DB'); if (!$dbh) { $dbh = & SGL_DB::singleton(); $locator->register('DB', $dbh); } return $dbh; } function getConfig() { $c = &SGL_Config::singleton(); return $c; } function validate($req, &$input) {} function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $mgrName = SGL_Inflector::caseFix(get_class($this)); $defaultMgrLoaded = false; if (SGL_Error::count()) { $oLastError = SGL_Error::getLast(); if ($oLastError->getCode() == SGL_ERROR_RESOURCENOTFOUND) { $defaultMgrLoaded = true; $output->addHeader('HTTP/1.1 404 Not Found'); } } elseif (!(array_key_exists($input->action, $this->_aActionsMapping))) { return SGL::raiseError('The specified method, ' . $input->action . ' does not exist', SGL_ERROR_NOMETHOD); } if (!count($this->conf)) { return SGL::raiseError('It appears you forgot to fire SGL_Manager\'s '. 'constructor - please add "parent::SGL_Manager();" in your '. 'manager\'s constructor.', SGL_ERROR_NOCLASS); } if ( isset($this->conf[$mgrName]['requiresAuth']) && $this->conf[$mgrName]['requiresAuth'] == true && $this->conf['debug']['authorisationEnabled']) { $mgrPerm = SGL_String::pseudoConstantToInt('SGL_PERMS_' . strtoupper($mgrName)); $ok = $this->_authorise($mgrPerm, $mgrName, $input); if ($ok !== true) { if (is_array($ok) && count($ok)) { list($className, $methodName) = $ok; SGL::logMessage('Unauthorised user '.SGL_Session::getUid() .' attempted to access ' . $className . '::' .$methodName, PEAR_LOG_WARNING); $lastRedirected = SGL_Session::get('redirected'); $now = time(); SGL_Session::set('redirected', $now); if ($now - $lastRedirected < 2) { $redirectTimes = SGL_Session::get('redirectedTimes'); $redirectTimes ++; SGL_Session::set('redirectedTimes', $redirectTimes); } else { SGL_Session::set('redirectedTimes', 0); } if (SGL_Session::get('redirectedTimes') > 2) { return PEAR::raiseError('infinite loop detected, clear cookies and check perms', SGL_ERROR_RECURSION); } SGL::raiseMsg('authorisation failed'); $aHistory = SGL_Session::get('aRequestHistory'); $aLastRequest = isset($aHistory[1]) ? $aHistory[1] : false; if ($aLastRequest) { $aRedir = array( 'managerName' => $aLastRequest['managerName'], 'moduleName' => $aLastRequest['moduleName'], ); } else { $aRedir = $this->getDefaultPageParams(); } SGL_HTTP::redirect($aRedir); } else { return PEAR::raiseError('unexpected response during authorisation check', SGL_ERROR_INVALIDAUTH); } } } if (!$defaultMgrLoaded) { foreach ($this->_aActionsMapping[$input->action] as $methodName) { $methodName = '_cmd_'.$methodName; $this->{$methodName}($input, $output); } } return true; } function _authorise($mgrPerm, $mgrName, $input) { if (!SGL_Session::hasPerms($mgrPerm) && !SGL::runningFromCLI()) { $ret = true; foreach ($this->_aActionsMapping[$input->action] as $methodName) { if (preg_match("/redirect/", $methodName)) { continue; } $methodName = '_cmd_' . $methodName; $perm = SGL_String::pseudoConstantToInt('SGL_PERMS_' . strtoupper($mgrName . $methodName)); if (SGL_Session::hasPerms($perm) === false) { $ret = array($mgrName, $methodName); break; } } } else { $ret = true; } return $ret; } function display(&$output) { if (!$output->manager->isValid()) { if (!count($output->aCssFiles)) { $cssFile = $output->request->get('cssFile'); if (!is_null($cssFile)) { $output->addCssFile($cssFile); } } } } function isValid() { return $this->validated; } function _cmd_redirectToDefault(&$input, &$output) { if (!SGL_Error::count()) { SGL_HTTP::redirect(); } else { $output->template = 'error.html'; } } function getDefaultPageParams() { $moduleName = $this->conf['site']['defaultModule']; $managerName = $this->conf['site']['defaultManager']; $defaultParams = $this->conf['site']['defaultParams']; $aDefaultParams = !empty($defaultParams) ? explode('/', $defaultParams) : array(); $aParams = array( 'moduleName' => $moduleName, 'managerName' => $managerName, ); $aRet = array(); if ($numElems = count($aDefaultParams)) { $aTmp = array(); for ($x = 0; $x < $numElems; $x++) { if ($x % 2) { $aTmp['varValue'] = urldecode($aDefaultParams[$x]); } else { $aTmp['varName'] = urldecode($aDefaultParams[$x]); } if (count($aTmp) == 2) { $aRet[$aTmp['varName']] = $aTmp['varValue']; $aTmp = array(); } } } $aMergedParams = array_merge($aParams, $aRet); return $aMergedParams; } function handleError($oError, &$output) { $output->template = 'error.html'; $output->masterTemplate = 'masterNoCols.html'; $output->aError = array( 'message' => $oError->getMessage(), 'debugInfo' => $oError->getDebugInfo(), 'level' => $oError->getCode(), 'errorType' => SGL_Error::constantToString($oError->getCode()) ); } } ?><?php
 class SGL_Output { var $onLoad = ''; var $aOnLoadEvents = array(); var $onUnload = ''; var $aOnUnloadEvents = array(); var $onReadyDom = ''; var $aOnReadyDomEvents = array(); var $aJavascriptFiles = array(); var $aRawJavascriptFiles = array(); var $aCssFiles = array(); var $aHeaders = array(); var $_aJsExportVars = array(); function translate($key, $filter = false, $aParams = array(), $output = null) { if (!empty($aParams) && is_string($aParams)) { $aResultParams = array(); $aStringParams = explode('||', $aParams); foreach ($aStringParams as $stringPair) { $aStringValues = explode('|', $stringPair); if (isset($aStringValues[1])) { if ($var = SGL_Output::_extractVariableValue($aStringValues[1], $output)) { $aResultParams[$aStringValues[0]] = $var; } else { if (isset($output) && is_a($output, 'SGL_Output')) { $aResultParams[$aStringValues[0]] = isset($output->{$aStringValues[1]}) ? $output->{$aStringValues[1]} : null; } elseif (is_a($this, 'SGL_Output')) { $aResultParams[$aStringValues[0]] = isset($this->{$aStringValues[1]}) ? $this->{$aStringValues[1]} : null; } } } else { if ($var = SGL_Output::_extractVariableValue($aStringValues[0], $output)) { $aStringValues[] = $var; } else { if (isset($output) && is_a($output, 'SGL_Output')) { $aResultParams[] = isset($output->{$aStringValues[0]}) ? $output->{$aStringValues[0]} : null; } elseif (is_a($this, 'SGL_Output')) { $aResultParams[] = isset($this->{$aStringValues[0]}) ? $this->{$aStringValues[0]} : null; } } } } $aParams = $aResultParams; } return SGL_String::translate($key, $filter, $aParams); } function _extractVariableValue($varString, $output = null) { $ret = false; if (strpos($varString, '.') !== false) { $aVar = explode('.', $varString); if (isset($output) && is_a($output, 'SGL_Output')) { $var = &$output->{$aVar[0]}; } else { $var = &$this->{$aVar[0]}; } if (isset($var) && is_object($var) && isset($var->{$aVar[1]})) { $ret = $var->{$aVar[1]}; } } return $ret; } function tr($key, $filter = false, $aParams = array(), $output = null) { return SGL_Output::translate($key, $filter, $aParams, $output); } function generateSelect($aValues, $selected = null, $multiple = false, $options = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (!is_array($aValues) || (isset($options) && !is_array($options))) { SGL::raiseError('Incorrect param passed to ' . __CLASS__ . '::' . __FUNCTION__, SGL_ERROR_INVALIDARGS); } if (is_numeric($selected)) { $selected = (int) $selected; } $optionsString = ''; if (isset($options)) { foreach ($options as $k => $v) { $optionsString .= ' ' . $k . '="' . $v . '"'; } } $r = ''; if ($multiple && is_array($selected)) { foreach ($aValues as $k => $v) { $isSelected = in_array($k, $selected) ? ' selected="selected"' : ''; $r .= "\n<option value=\"$k\"" . $isSelected . $optionsString . ">$v</option>"; } } else { $r = ''; foreach ($aValues as $k => $v) { $isSelected = ($k === $selected && !is_null($selected)) ? ' selected="selected"' : ''; $r .= "\n<option value=\"$k\"". $isSelected . $optionsString . ">$v</option>"; } } return $r; } function generateCheckboxList($hElements, $aChecked, $groupName, $options = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (!is_array($hElements) || !is_array($aChecked) || (isset($options) && !is_array($options))) { SGL::raiseError('Incorrect param passed to ' . __CLASS__ . '::' . __FUNCTION__, SGL_ERROR_INVALIDARGS); return false; } $optionsString = ''; if (isset($options)) { foreach ($options as $k => $v) { $optionsString .= ' ' . $k . '="' . $v . '"'; } } $html = ''; foreach ($hElements as $k => $v) { $isChecked = (in_array($k, $aChecked)) ? ' checked' : ''; $html .= "<input class='noBorder' type='checkbox' name='$groupName' " . "id='$groupName-$k' value='$k'" . $optionsString . " $isChecked><label for='$groupName-$k'>$v</label><br />\n"; } return $html; } function generateCheckbox($name, $value, $checked, $options = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (isset($options) && !is_array($options)) { SGL::raiseError('Incorrect param passed to ' . __CLASS__ . '::' . __FUNCTION__, SGL_ERROR_INVALIDARGS); return false; } $isChecked = $checked ? ' checked' : ''; $optionsString = ''; if (isset($options)) { foreach ($options as $k => $v) { $optionsString .= ' ' . $k . '="' . $v . '"'; } } $html = "<input class='noBorder' type='checkbox' name='$name' " . "id= '$name' value='$value'" . $optionsString . " $isChecked><label for='$name'>$value</label><br />\n"; return $html; } function generateRadioPair($radioName, $checked, $options = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (isset($options) && !is_array($options)) { SGL::raiseError('Incorrect param passed to ' . __CLASS__ . '::' . __FUNCTION__, SGL_ERROR_INVALIDARGS); return false; } $radioString = ''; if ($checked) { $yesChecked = ' checked="checked"'; $noChecked = ''; } else { $yesChecked = ''; $noChecked = ' checked="checked"'; } $optionsString = ''; if (isset($options)) { foreach ($options as $k => $v) { $optionsString .= ' ' . $k . '="' . $v . '"'; } } $radioString .= "<input type='radio' name='$radioName' value='0'" . $optionsString . " $noChecked />".SGL_String::translate('no')."\n"; $radioString .= "<input type='radio' name='$radioName' value='1'" . $optionsString . " $yesChecked />".SGL_String::translate('yes')."\n"; return $radioString; } function generateRadioList($elements, $selected, $groupname, $newline = false, $inTable = true, $options = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (!is_array($elements) || (isset($options) && !is_array($options))) { SGL::raiseError('Incorrect param passed to ' . __CLASS__ . '::' . __FUNCTION__, SGL_ERROR_INVALIDARGS); return false; } $elementcount = count($elements); $html = ''; $i = 0; $optionsString = ''; if (isset($options)) { foreach ($options as $k => $v) { $optionsString .= ' ' . $k . '="' . $v . '"'; } } if ($inTable){ foreach ($elements as $k => $v) { $i = $i + 1; $html .= "<input name='" . $groupname . "' type='radio' value='" . $k . "'" . $optionsString . " "; if ($selected == $k ){ $html .= " checked='checked'"; } $html .= " />$v "; if ($newline) { $modvalue = $i % $newline; if ($modvalue == 0 ) { $html .= "<br/>\n"; } } } } else { $html ="<table>"; $html .="<tr>"; foreach ($elements as $k => $v) { $i = $i + 1; $html .= "<td nowrap='nowrap'><input name='" . $groupname . "' type='radio' value='" . $k . "'" . $optionsString . " "; if ($selected == $k ) { $html .= " checked='checked'"; } $html .= " />$v </td>\n"; if ($newline) { $modvalue = $i % $newline; if ( $modvalue == 0 ) { if ($i < $elementcount){ $html .="</tr>\n<tr>"; } else { $html .="</tr>\n"; } } } } $html .="</table>"; } return $html; } function formatBytes($size) { return SGL_String::formatBytes($size); } function formatDate($date = '') { if (empty($date)) { $date = SGL_Date::getTime(); } return SGL_Date::format($date); } function formatDatePretty($date = '') { if (empty($date)) { $date = SGL_Date::getTime(); } return SGL_Date::formatPretty($date); } function getDateFormat() { return SGL_Date::getDateFormat(); } function showDateSelector($aDate, $sFormName, $bShowTime = true, $asc = true, $years = 5) { return SGL_Date::showDateSelector($aDate, $sFormName, $bShowTime, $asc, $years); } function getNoExpiryCheckbox($aDate,$sFormName) { $checked = ($aDate == null) ? 'checked' : ''; return '<input type="checkbox" name="'.$sFormName.'NoExpire" id="'.$sFormName .'NoExpire" value="true" onClick="time_select_reset(\''.$sFormName.'\',true);"  ' .$checked.' /> '.SGL_Output::translate('No expire'); } function switchRowClass($isBold = false, $pColor = 'backDark', $sColor = 'backLight', $id = 'default') { static $curRowClass; static $_id; if ($_id != $id) { $curRowClass = ''; $_id = $id; } if (strpos($curRowClass, $sColor) === false) { $curRowClass = $sColor; } else { $curRowClass = $pColor; } if ($isBold) { $curRowClass .= ' bold'; } return $curRowClass; } function switchTrueFalse($elementsToCount=2) { static $count; if (empty($elementsToCount)) { $count = 0; return; } if ($count % $elementsToCount) { $switcher = false; } else { $switcher = true; } $count++; return $switcher; } function summarise($str, $limit=50, $element=SGL_WORD, $appendString=' ...') { $ret = SGL_String::summarise($str, $limit, $element, $appendString); return $ret; } function msgGetAdmin() { SGL::logMessage(null, PEAR_LOG_DEBUG); $message = SGL_Session::get('message'); $messageType = SGL_Session::get('messageType'); if (isset($message) && $message != '') { SGL_Session::remove('message'); SGL_Session::remove('messageType'); switch ($messageType) { case SGL_MESSAGE_INFO: $class = 'info'; break; case SGL_MESSAGE_WARNING: $class = 'warning'; break; default: $class = 'error'; } echo '<div class="' . $class . 'Message">' . $message . '</div>'; unset($GLOBALS['message']); unset($GLOBALS['messageType']); } if (SGL_Error::count()) { while ($msg = SGL_Error::pop()) { $msg = SGL_Error::toString($msg); echo '  <div class="errorContainer">
                            <div class="errorHeader">Error</div>
                            <div class="errorContent">' . $msg . '</div>
                        </div>'; } } else { return false; } } function isAdmin($rid = null) { if (is_null($rid)) { $rid = SGL_Session::getRoleId(); } return ($rid && $rid == SGL_ADMIN) ? true : false; } function isAdminOrUnassigned($rid) { return (abs($rid) == SGL_ADMIN) ? true : false; } function isAuthenticated() { $rid = SGL_Session::getRoleId(); return ($rid == SGL_GUEST) ? false : true; } function addOnLoadEvent($event, $bOnReady = false) { if ($bOnReady) { $this->aOnReadyDomEvents[] = $event; } else { $this->aOnLoadEvents[] = $event; } } function addOnUnloadEvent($event) { $this->aOnUnloadEvents[] = $event; } function getOnLoadEvents() { $c = & SGL_Config::singleton(); $conf = $c->getAll(); if (!empty($conf['site']['globalJavascriptOnload'])) { $this->aOnLoadEvents[] = $conf['site']['globalJavascriptOnload']; } if (count($this->aOnLoadEvents)) { return $this->aOnLoadEvents; } } function getOnUnloadEvents() { $c = & SGL_Config::singleton(); $conf = $c->getAll(); if (!empty($conf['site']['globalJavascriptOnUnload'])) { $this->aOnUnloadEvents[] = $conf['site']['globalJavascriptOnUnload']; } if (count($this->aOnUnloadEvents)) { return $this->aOnUnloadEvents; } } function getOnReadyDomEvents() { $c = & SGL_Config::singleton(); $conf = $c->getAll(); if (!empty($conf['site']['globalJavascriptOnReadyDom'])) { $this->aOnReadyDomEvents[] = $conf['site']['globalJavascriptOnReadyDom']; } if (count($this->aOnReadyDomEvents)) { return $this->aOnReadyDomEvents; } } function addJavascriptFile($file, $optimize = true) { if ($optimize) { $aFiles = &$this->aJavascriptFiles; } else { $aFiles = &$this->aRawJavascriptFiles; } $aIncludeFiles = !is_array($file) ? array($file) : $file; foreach ($aIncludeFiles as $jsFile) { $jsFile = strpos($jsFile, 'http://') === 0 ? $jsFile : SGL_BASE_URL . '/' . $jsFile; if (!in_array($jsFile, $aFiles)) { $aFiles[] = $jsFile; } } } function getJavascriptFiles() { $aFiles = array(); $c = & SGL_Config::singleton(); $conf = $c->getAll(); if (!empty($conf['site']['globalJavascriptFiles'])) { $aTmp = explode(';', $conf['site']['globalJavascriptFiles']); foreach ($aTmp as $file) { $aFiles[] = (strpos($file, 'http://') === 0) ? $file : SGL_BASE_URL . '/' . $file; } } if (isset($this->javascriptSrc)) { if (is_array($this->javascriptSrc)) { foreach ($this->javascriptSrc as $file) { $aFiles[] = (strpos($file, 'http://') === 0) ? $file : SGL_BASE_URL . '/' . $file; } } else { $aFiles[] = (strpos($this->javascriptSrc, 'http://') === 0) ? $this->javascriptSrc : SGL_BASE_URL . '/' . $this->javascriptSrc; } } if (count($this->aJavascriptFiles)) { $aFiles = array_merge( $aFiles, $this->aJavascriptFiles ); } return $aFiles; } function addCssFile($file) { if (is_array($file)) { foreach ($file as $cssFile) { if (!in_array($cssFile, $this->aCssFiles)) { $this->aCssFiles[] = $cssFile; } } } else { if (!in_array($file, $this->aCssFiles)) { $this->aCssFiles[] = $file; } } } function makeUrl($action = '', $mgr = '', $mod = '', $aList = array(), $params = '', $idx = 0) { $input = &SGL_Registry::singleton(); $req = $input->getRequest(); if ($req->type == SGL_REQUEST_BROWSER && SGL_Config::get('site.inputUrlHandlers') == 'Horde_Routes') { $aArgs = func_get_args(); if (count($aArgs) == 1) { if (strpos($aArgs[0], '|') !== false) { $aVars = explode('||', $aArgs[0]); $aArgs = array(); foreach ($aVars as $varString) { list($k, $v) = explode('|', $varString); $aArgs[$k] = isset($this->{$v}) ? $this->{$v} : $v; } if (isset($aArgs['module'])) { $aArgs['moduleName'] = $aArgs['module']; unset($aArgs['module']); } if (isset($aArgs['manager'])) { $aArgs['managerName'] = $aArgs['manager']; unset($aArgs['manager']); } } else { $aArgs = $aArgs[0]; } } elseif (count($aArgs) == 5 && empty($aList)) { $aVars = explode('||', $aArgs[4]); foreach ($aVars as $varKey => $varString) { $aVar = explode('|', $varString); if (isset($aVar[1]) && isset($this->{$aVar[1]})) { $aVar[1] = $this->{$aVar[1]}; } $aVars[$varKey] = implode('|', $aVar); } $aArgs[4] = implode('||', $aVars); } $url = $input->getCurrentUrl(); $ret = $url->makeLink($aArgs); } else { $ret = SGL_Url::makeLink($action, $mgr, $mod, $aList, $params, $idx, $this); } return $ret; } function loadBlocks($moduleName = '', $blockName = '') { $blockPath = SGL_MOD_DIR . '/' . $moduleName . '/blocks/' . $blockName . '.php'; if (is_file($blockPath)){ require_once SGL_MOD_DIR . '/' . $moduleName . '/blocks/' . $blockName . '.php'; $className = ucfirst($moduleName) . '_Block_' . ucfirst($blockName); eval("\$oBlock = new $className();"); $output = $this; $blockContent = $oBlock->getBlockContent($output, $aParams); echo $blockContent; } } function getCurrentUrl() { $reg =& SGL_Registry::singleton(); $oCurrentUrl = $reg->getCurrentUrl(); return $oCurrentUrl->toString(); } function isVerticalNav($styleSheet) { return in_array($styleSheet, array('SglListamaticSubtle', 'verticalSimple')); } function outputBody($templateEngine = null) { if (empty($this->template)) { $this->template = 'null.html'; } $this->masterTemplate = $this->template; $view = &new SGL_HtmlSimpleView($this, $templateEngine); echo $view->render(); SGL::setNoticeBehaviour(SGL_NOTICES_DISABLED); } function outputComponentBody() { if (class_exists('RVFlexyStrategy')) { $this->masterTemplate = $this->template; $view = new RVFlexyStrategy($this, $templateEngine); echo $view->render($this); } } function isWin() { return SGL_CLIENT_OS == 'Win'; } function isEqual($a, $b) { return $a == $b; } function assign(&$a, $b) { $a = $b; return; } function increment($int) { return ++ $int; } function isChecked($value) { if ($value) { $ret = 'checked="checked"'; } else { $ret = ''; } return $ret; } function getCurrentModule() { $reg =& SGL_Registry::singleton(); $req = $reg->getRequest(); $frmCallerMod = $req->get('frmCallerMod'); $modName = (is_null($frmCallerMod)) ? $req->getModuleName() : $frmCallerMod; return $modName; } function getCurrentManager() { $reg =& SGL_Registry::singleton(); $req = $reg->getRequest(); $frmCallerMgr = $req->get('frmCallerMgr'); $mgrName = (is_null($frmCallerMgr)) ? $req->getManagerName() : $frmCallerMgr; return $mgrName; } function getCurrentTemplate() { $reg =& SGL_Registry::singleton(); $req = $reg->getRequest(); $frmCallerTmpl = $req->get('frmCallerTmpl'); $tmplName = (is_null($frmCallerTmpl)) ? $this->template : $frmCallerTmpl; return $tmplName; } function getCurrentId() { $reg =& SGL_Registry::singleton(); $req = $reg->getRequest(); $frmCallerId = $req->get('frmCallerId'); $id = (is_null($frmCallerId)) ? $this->articleID : $frmCallerId; return $id; } function hasPerms($permName) { $permId = @constant('SGL_PERMS_' . strtoupper($permName)); return (!empty($permId) && SGL_Session::hasPerms($permId) ? true : false); } function printf() { $argv = func_get_args(); return @call_user_func_array('sprintf', $argv); } function makeCssLink($theme, $navStylesheet, $moduleName) { if (is_file(SGL_MOD_DIR . "/$moduleName/www/css/$moduleName.php")) { $ret = SGL_BASE_URL . "/themes/$theme/css/style.php?navStylesheet=$navStylesheet&moduleName=$moduleName&isSymlink=1"; } else { $ret = SGL_BASE_URL . "/themes/$theme/css/style.php?navStylesheet=$navStylesheet&moduleName=$moduleName"; } return $ret; } function humanise($lowerCaseAndUnderscoredWord) { return SGL_Inflector::humanise($lowerCaseAndUnderscoredWord); } function camelise($lowerCaseWithSpacesWordsString) { return SGL_Inflector::camelise($lowerCaseWithSpacesWordsString); } function getExecutionTime() { return getSystemTime() - @SGL_START_TIME; } function getQueryCount() { return $GLOBALS['_SGL']['QUERY_COUNT']; } function getMemoryUsage() { if (function_exists('memory_get_usage')) { return number_format(memory_get_usage()); } else { return 'unknown'; } } function addHeader($header) { if (!in_array($header, $this->aHeaders)) { $this->aHeaders[] = $header; } } function getHeaders() { return $this->aHeaders; } function makeJsOptimizerLink() { $aCurrentFiles = $this->aJavascriptFiles; $this->aJavascriptFiles = array(); if (!SGL_Config::get('site.globalJavascriptFiles') && ($_SESSION['aPrefs']['theme'] == 'default' || $this->adminGuiAllowed)) { SGL_Config::set('site.globalJavascriptFiles', 'js/SGL.js,themes/rvtheme/js/web.js'); } $this->addJavascriptFile( SGL_Config::get('site.globalJavascriptFiles') ? explode(',', SGL_Config::get('site.globalJavascriptFiles')) : array() ); $this->addJavascriptFile($aCurrentFiles); $aFiles = array(); foreach ($this->aJavascriptFiles as $fileName) { $aFiles[] = substr($fileName, strlen(SGL_BASE_URL . '/')); } $rev = SGL_Output::_getFilesModifiedTime($aFiles); $jsString = implode(',', $aFiles); $link = SGL_BASE_URL . '/optimizer.php?type=javascript&amp;rev=' . $rev . '&amp;files=' . $jsString; if (SGL_Config::get('cache.javascript')) { $link .= '&amp;optimize=1'; } $ret = "<script type=\"text/javascript\" src=\"$link\"></script>\n"; foreach ($this->aRawJavascriptFiles as $jsFile) { $ret .= "<script type=\"text/javascript\" src=\"$jsFile\"></script>\n"; } return $ret; } function makeCssOptimizerLink($aCssHelperParams = array(), $aDefaultThemeFiles = null, $themePreloadFile = null) { $theme = $this->theme; $masterLayout = !empty($this->masterLayout) ? $this->masterLayout : 'layout-navtop-2col_localleft.css'; $req = &SGL_Request::singleton(); $masterLayout = $req->get('masterLayout') ? $req->get('masterLayout') : $masterLayout; $this->masterLayout = $masterLayout; if (!empty($aDefaultThemeFiles) && is_string($aDefaultThemeFiles)) { $aTmpThemeFiles = explode(',', $aDefaultThemeFiles); $aDefaultThemeFiles = array(); foreach ($aTmpThemeFiles as $file) { $aDefaultThemeFiles[] = "themes/$theme/css/$file"; } } if (!is_array($aDefaultThemeFiles) && is_null($aDefaultThemeFiles)) { $aDefaultThemeFiles = array( "themes/$theme/css/reset.css", "themes/$theme/css/tools.css", "themes/$theme/css/typo.css", "themes/$theme/css/forms.css", "themes/$theme/css/layout.css", "themes/$theme/css/blocks.css", "themes/$theme/css/common.css", "themes/$theme/css/$masterLayout", ); } elseif (!is_array($aDefaultThemeFiles)) { $aDefaultThemeFiles = array(); } if ($theme == 'rvtheme') { $aDefaultThemeFiles[] = "themes/$theme/css/style.css"; } $aCurrentFiles = $this->aCssFiles; $this->aCssFiles = array(); $this->addCssFile($aDefaultThemeFiles); $this->addCssFile($aCurrentFiles); $module = !empty($this->moduleName) ? $this->moduleName : 'default'; $defaultModule = SGL_Config::get('site.defaultModule') ? SGL_Config::get('site.defaultModule') : $module; $aCssHelperParams['theme'] = $theme; $aCssHelperParams['langDir'] = $this->langDir; $aCssHelperParams['isFormSubmitted'] = !empty($this->submitted); $aCssHelperParams['module'] = $module; $aCssHelperParams['defaultModule'] = $defaultModule; if (is_file(realpath(SGL_WEB_ROOT . "/$module/css/$module.css"))) { $this->addCssFile("$module/css/$module.css"); } elseif (is_file(realpath(SGL_WEB_ROOT . "/themes/$theme/css/$module.css"))) { $this->addCssFile("themes/$theme/css/$module.css"); } if (is_file(realpath(SGL_WEB_ROOT . "/$module/css/$module.php"))) { $this->addCssFile("$module/css/$module.php"); } elseif (is_file(realpath(SGL_WEB_ROOT . "/themes/$theme/css/$module.php"))) { $this->addCssFile("themes/$theme/css/$module.php"); } $params = ''; foreach ($aCssHelperParams as $k => $v) { $params .= '&amp;aParams[' . urlencode($k) . ']=' . urlencode($v); } if (!SGL_Config::get('debug.production')) { $ret = ''; $rev = time(); foreach ($this->aCssFiles as $file) { $aFiles = array(); if (!empty($themePreloadFile)) { $aFiles[] = "themes/$theme/css/$themePreloadFile"; } $aFiles[] = $file; $cssString = implode(',', $aFiles); $link = SGL_BASE_URL . "/optimizer.php?type=css&amp;rev=$rev&amp;files=" . $cssString . $params; $ret .= "<link rel=\"stylesheet\" type=\"text/css\" href=\"$link\" />\n"; } } else { $aFiles = !empty($themePreloadFile) ? array_merge( array("themes/$theme/css/$themePreloadFile"), $this->aCssFiles ) : $this->aCssFiles; $rev = SGL_Output::_getFilesModifiedTime($aFiles); $cssString = implode(',', $aFiles); $link = SGL_BASE_URL . "/optimizer.php?type=css&amp;rev=$rev&amp;files=" . $cssString . $params; $ret = "<link rel=\"stylesheet\" type=\"text/css\" href=\"$link\" />\n"; } $this->aCssFiles = $aCurrentFiles; return $ret; } function _getFilesModifiedTime($aFiles) { $lastMod = 0; foreach ($aFiles as $fileName) { if (is_file(realpath(SGL_WEB_ROOT . '/' . $fileName))) { $lastMod = max($lastMod, filemtime(SGL_WEB_ROOT . '/' . $fileName)); } } return $lastMod; } function msgGet() { if ($this->adminGuiAllowed) { return SGL_Output::msgGetAdmin(); } $message = SGL_Session::get('message'); $messageType = SGL_Session::get('messageType'); $html = ''; if (!empty($message)) { SGL_Session::remove('message'); SGL_Session::remove('messageType'); switch ($messageType) { case SGL_MESSAGE_INFO: $class = 'info'; break; case SGL_MESSAGE_WARNING: $class = 'warning'; break; default: $class = 'error'; break; } $html .= "<p class=\"message-{$class}\">$message</p>"; unset($GLOBALS['message']); unset($GLOBALS['messageType']); } if (SGL_Error::count()) { while ($msg = SGL_Error::pop()) { $msg = SGL_Error::toString($msg); $html .= "<h4>Error</h4><p class=\"pear\">$msg</p>"; } } if (empty($html)) { $html = '<!-- Do not remove, MSIE fix -->'; } echo $html; } function getLangDirection() { $ret = $this->langDir == 'rtl' ? 'right' : 'left'; return $ret; } function getLangDirectionOpposite() { $ret = $this->langDir == 'rtl' ? 'left' : 'right'; return $ret; } function exportJsVar($k, $v, $replace = true) { $k = strtoupper($k); if ($replace) { $this->_aJsExportVars[$k] = $v; } elseif (!array_key_exists($k, $this->_aJsExportVars)) { $this->_aJsExportVars[$k] = $v; } } function getExportedJsVars() { $prefix = 'SGL'; $ret = ''; foreach ($this->_aJsExportVars as $k => $v) { $varName = $prefix . '_' . $k; $varVal = addcslashes($v, '"'); $ret .= "var $varName = \"$varVal\";\n"; } return $ret; } function isCurrentModule($module='') { if ($module == '' || strtolower($module) == strtolower($this->getCurrentModule())) { return true; } else { return false; } } function isCurrentManager($manager ='') { if ($manager == '' || strtolower($manager) == strtolower($this->getCurrentModule())) { return true; } else { return false; } } function isCurrentAction($cAction ='' , $action ='') { if ($action == '' || strtolower($action) == strtolower($cAction)) { return true; } else { return false; } } function isModuleShowCssClass($classname = '', $module, $manager = '', $currentAction ='', $action="") { if ($this->isCurrentModule($module) && $this->isCurrentManager($manager) && $this->isCurrentAction($currentAction, $action) && $classname != '') { printf('class="%s"', $classname); } } function isModule($module, $manager = '', $currentAction ='', $action="") { if ($this->isCurrentModule($module) && $this->isCurrentManager($manager) && $this->isCurrentAction($currentAction, $action)) { return true; } else { return false; } } function isCountTd($column = 3,$all) { if ($GLOBALS['_SGL']['RVS']['countTd']['countTd'] == '') { $GLOBALS['_SGL']['RVS']['countTd']['countTd'] = 1; } $countTd = $GLOBALS['_SGL']['RVS']['countTd']['countTd']++; if ($column == $countTd) { $GLOBALS['_SGL']['RVS']['countTd']['countTd'] = 1; $GLOBALS['_SGL']['RVS']['countTd']['countAll'] = 0; return true; } else { $GLOBALS['_SGL']['RVS']['countTd']['countAll']++; return false; } } function isCheckColspan($column = 3, $mode = false) { $colspan = $GLOBALS['_SGL']['RVS']['countTd']['colspan']; $countAll = $GLOBALS['_SGL']['RVS']['countTd']['countAll']; if ($countAll != 0) { $colspan = $column - $countAll; } else { $GLOBALS['_SGL']['RVS']['countTd']['colspan'] = ''; } if ($mode == 'unset') { $GLOBALS['_SGL']['RVS']['countTd']['colspan'] = ''; $GLOBALS['_SGL']['RVS']['countTd']['countTd'] = ''; $GLOBALS['_SGL']['RVS']['countTd']['countAll'] = ''; return false; } else { return $colspan; } } function moduleIsEnabled($module) { if (SGL::moduleIsEnabled($module)) { return true; } else { return false; } } function mbString($message = '', $maxChar = 50, $format = '{{message}} <a href="{{link}}">read more</a>') { if (strlen($message) <= 0) { return '<p>' . SGL_Output::translate('No record.') . '</p>'; } $argv = func_get_args(); $aArgs['action'] = $argv[3]; $aArgs['managerName'] = $argv[4]; $aArgs['moduleName'] = $argv[5]; unset($argv[0]); unset($argv[1]); unset($argv[2]); unset($argv[3]); unset($argv[4]); unset($argv[5]); $message = preg_replace("#<(.*?)>#si", '', $message); if($maxChar < strlen($message)) { $message = mb_substr($message, 0, $maxChar); $message .= '...'; } $link = join("/", $argv); $ret = SGL_Output::makeUrl($aArgs['action'],$aArgs['managerName'],$aArgs['moduleName']); $ret .= $link; $format = preg_replace('#{{message}}#si', $message, $format); $format = preg_replace('#{{link}}#si', $ret, $format); return $format; } } ?><?php
 define('SGL_CENSOR_DISABLE', 0); define('SGL_CENSOR_EXACT_MATCH', 1); define('SGL_CENSOR_WORD_BEGINNING', 2); define('SGL_CENSOR_WORD_FRAGMENT', 3); class SGL_String { function censor($text) { SGL::logMessage(null, PEAR_LOG_DEBUG); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $editedText = $text; $censorMode = SGL_String::pseudoConstantToInt($conf['censor']['mode']); if ($censorMode != SGL_CENSOR_DISABLE) { $aBadWords = explode(',', $conf['censor']['badWords']); if (is_array($aBadWords)) { $replacement = $conf['censor']['replaceString']; switch ($censorMode) { case SGL_CENSOR_EXACT_MATCH: $regExPrefix = '(\s*)'; $regExSuffix = '(\W*)'; break; case SGL_CENSOR_WORD_BEGINNING: $regExPrefix = '(\s*)'; $regExSuffix = '(\w*)'; break; case SGL_CENSOR_WORD_FRAGMENT: $regExPrefix = '(\w*)'; $regExSuffix = '(\w*)'; break; } for ($i = 0; $i < count($aBadWords); $i++ ) { $editedText = eregi_replace( $regExPrefix . $aBadWords[$i] . $regExSuffix, "\\1$replacement\\2", $editedText); } } } return $editedText; } function getCrlf() { SGL::logMessage(null, PEAR_LOG_DEBUG); $crlf = (substr(PHP_OS, 0, 3) == 'WIN') ? "\r\n" : "\n"; return $crlf; } function trimWhitespace($var) { if (!isset($var)) { return false; } if (is_array($var)) { $newArray = array(); foreach ($var as $key => $value) { $newArray[$key] = SGL_String::trimWhitespace($value); } return $newArray; } else { return trim($var); } } function dispelMagicQuotes(&$var) { static $magicQuotes; if (!isset($magicQuotes)) { $magicQuotes = get_magic_quotes_gpc(); } if ($magicQuotes) { if (!is_array($var)) { $var = stripslashes($var); } else { array_walk($var, array('SGL_String', 'dispelMagicQuotes')); } } } function clean($var) { if (!isset($var)) { return false; } $var = SGL_String::trimWhitespace($var); if (is_array($var)) { $newArray = array(); foreach ($var as $key => $value) { $newArray[$key] = SGL_String::clean($value); } return $newArray; } else { return strip_tags($var); } } function removeJs($var) { if (!isset($var)) { return false; } $var = SGL_String::trimWhitespace($var); if (is_array($var)) { $newArray = array(); foreach ($var as $key => $value) { $newArray[$key] = SGL_String::removeJs($value); } return $newArray; } else { $search = "/<script[^>]*?>.*?<\/script\s*>/i"; $replace = ''; $clean = preg_replace($search, $replace, $var); return $clean; } } function tidy($html, $logErrors = false) { SGL::logMessage(null, PEAR_LOG_DEBUG); $c = &SGL_Config::singleton(); $conf = $c->getAll(); if ( !$conf['site']['tidyhtml'] || !extension_loaded('tidy')) { return $html; } if (SGL::isPhp5()) { $options = array( 'wrap' => 0, 'indent' => true, 'indent-spaces' => 4, 'output-xhtml' => true, 'drop-font-tags' => false, 'clean' => false, ); if (strlen($html)) { $tidy = new Tidy(); $tidy->parseString($html, $options, 'utf8'); $tidy->cleanRepair(); $ret = $tidy->body(); } } else { tidy_setopt('show-body-only', true); tidy_setopt('wrap', 0); tidy_setopt('indent', 1); tidy_setopt('indent-spaces', 1); tidy_parse_string($html); if ((tidy_warning_count() || tidy_error_count()) && $logErrors) { SGL::logMessage('PHP Tidy error or warning: ' . tidy_get_error_buffer(), PEAR_LOG_NOTICE); } $ret = tidy_get_output(); } return $ret; } function translate($key, $filter = false, $aParams = array()) { $c = &SGL_Config::singleton(); $conf = $c->getAll(); $trans = &$GLOBALS['_SGL']['TRANSLATION']; if (isset($trans[$key])) { if (!is_array($trans[$key]) && strstr($trans[$key], '||') && $conf['translation']['container'] == 'db') { preg_match_all('/([^|]*)\|([^|]*)(?=\|\|)/', $trans[$key], $aPieces); $ret = array_combine($aPieces[1], $aPieces[2]); } else { $ret = $trans[$key]; } if (!is_array($trans[$key]) && $filter && function_exists($filter)) { if (is_object($aParams)) { $aParams = (array)$aParams; } if (!empty($aParams) && is_array($aParams) && $filter == 'vprintf') { $i = 1; foreach ($aParams as $key => $value) { if (!empty($value) && !is_scalar($value)) { continue; } $value = str_replace('%', '%%', $value); $ret = str_replace("%$i%", $value, $ret); $ret = str_replace("%$i", $value, $ret); $ret = str_replace("%$key%", $value, $ret); $ret = str_replace("%$key", $value, $ret); $i++; } $ret = vsprintf($ret, $aParams); } else { $ret = $filter($ret); } } return $ret; } else { if (!empty($key) && isset($conf['translation']['addMissingTrans']) && $conf['translation']['addMissingTrans'] && isset($conf['translation']['container']) && $conf['translation']['container'] == 'db') { $req = & SGL_Request::singleton(); $moduleName = $req->get('moduleName'); $fallbackLang = $conf['translation']['fallbackLang']; $trans = &SGL_Translation::singleton('admin'); $result = $trans->add($key, $moduleName, array($fallbackLang => $key)); } SGL::logMessage('Key \''.$key.'\' Not found', PEAR_LOG_NOTICE); $key = (isset($conf['debug']['showUntranslated']) && $conf['debug']['showUntranslated']) ? '>' . $key . '<' : $key; return $key; } } function char2entity($char, $encoding = 'H') { $pad = 1; if ($encoding == 'R' || $encoding == 'E') { $pad = rand(2, 7); if ($encoding == 'R') { $encoding = rand(1, 3); } else { $encoding = rand(1, 2); } } $asc = ord($char); switch ($encoding) { case 1: case 'D': return sprintf("&#%0{$pad}d;", $asc); break; case 2: case 'H': return sprintf("&#x%0{$pad}X;", $asc); break; case 3: case 'U': return sprintf("%%%02X", $asc); break; default: return $char; } } function obfuscate($str) { $encoded = bin2hex($str); $encoded = chunk_split($encoded, 2, '%'); $encoded = '%' . substr($encoded, 0, strlen($encoded) - 1); return $encoded; } function obfuscate2($str, $bForLink = true) { if ($bForLink) { $e = "'R'"; } else { $e = "'E'"; } $encoded = preg_replace_callback( '|([-?=@._emailto:])|', create_function( '$matches', "return char2entity(\$matches[0], $e);" ), $str ); return $encoded; } function obfuscate3($address) { $at = '(at)'; $dot = '(dot)'; $len = strlen($address); $pos = strpos($address, '@'); $name = substr($address, 0, $pos-$len); $domain = $at . substr($address, $pos+1); $domain = preg_replace('/\./', $dot, $domain); return $name . $domain; } function mungeMailAddress($address) { $len = strlen($address); $aOld = str_split($address); $aMunged = array(); for ($i = 0; $i < $len; $i++) { $aMunged[$i] = "&#" . ord($aOld[$i]) . ";"; } $munged = implode('' ,$aMunged); return $munged; } function summarise($str, $limit = 50, $element = SGL_WORD, $appendString = ' ...') { switch ($element) { case SGL_CHAR: if (extension_loaded('mbstring')) { $enc = mb_detect_encoding($str); $len = mb_strlen($str, $enc); $ret = $len > $limit ? mb_substr($str, 0, $limit, $enc) . $appendString : $str; } else { $len = strlen($str); $ret = $len > $limit ? substr($str, 0, $limit) . $appendString : $str; } break; case SGL_WORD: $aWords = explode(' ', $str); if (count($aWords) > $limit) { $ret = implode(' ', array_slice($aWords, 0, $limit)) . $appendString; } else { $ret = $str; } break; } return $ret; } function summariseHtml($str, $lines=10) { $aLines = explode("\n", $str); $aSegment = array_slice($aLines, 0, $lines); $unclosedListTags = 0; $aMatches = array(); foreach ($aSegment as $line) { if (preg_match("/<[u|o]l/i", $line, $matches)) { $aMatches[] = $matches; $unclosedListTags++; } if (preg_match("/<\/[u|o]l>/i", $line)) { $unclosedListTags--; } } for ($x=0; $x < $unclosedListTags; $x++) { array_push($aSegment, '</ul>'); } $ret = implode("\n", $aSegment); $ret = SGL_String::tidy($ret); return $ret; } function formatBytes($size, $decimals = 1, $lang = '--') { $aSizeList = array(1073741824, 1048576, 1024, 0); if ($lang == 'FR') { $aSizeNameList = array('&nbsp;Go', '&nbsp;Mo', '&nbsp;Ko', '&nbsp;octets'); } else { $aSizeNameList = array('GB', 'MB', 'KB', 'B'); } $i = 0; foreach ($aSizeList as $bytes) { if ($size >= $bytes) { if ($bytes == 0) { $bytes = 1; $decimals = 0; } $formated = sprintf("%.{$decimals}f{$aSizeNameList[$i]}", $size / $bytes); break; } $i++; } return $formated; } function toValidVariableName($str) { $search = '/[^a-zA-Z1-9_]/'; $replace = ''; $res = preg_replace($search, $replace, $str); $firstLetter = strtolower($res[0]); $final = substr_replace($res, $firstLetter, 0, 1); return $final; } function toValidFileName($origName) { return SGL_String::dirify($origName); } function dirify($s) { $s = SGL_String::convertHighAscii($s); $s = strtolower($s); $s = strip_tags($s); $s = preg_replace('!&#?[A-Za-z0-9]{1,7};?!', '', $s); $s = preg_replace('![^\w\s-]!', '',$s); $s = preg_replace('!\s+!', '_',$s); return $s; } function convertHighAscii($s) { $aHighAscii = array( "!\xc0!" => 'A', "!\xe0!" => 'a', "!\xc1!" => 'A', "!\xe1!" => 'a', "!\xc2!" => 'A', "!\xe2!" => 'a', "!\xc4!" => 'A', "!\xe4!" => 'a', "!\xc3!" => 'A', "!\xe3!" => 'a', "!\xc8!" => 'E', "!\xe8!" => 'e', "!\xc9!" => 'E', "!\xe9!" => 'e', "!\xca!" => 'E', "!\xea!" => 'e', "!\xcb!" => 'E', "!\xeb!" => 'e', "!\xcc!" => 'I', "!\xec!" => 'i', "!\xcd!" => 'I', "!\xed!" => 'i', "!\xce!" => 'I', "!\xee!" => 'i', "!\xcf!" => 'I', "!\xef!" => 'i', "!\xd2!" => 'O', "!\xf2!" => 'o', "!\xd3!" => 'O', "!\xf3!" => 'o', "!\xd4!" => 'O', "!\xf4!" => 'o', "!\xd6!" => 'O', "!\xf6!" => 'o', "!\xd5!" => 'O', "!\xf5!" => 'o', "!\xd8!" => 'O', "!\xf8!" => 'o', "!\xd9!" => 'U', "!\xf9!" => 'u', "!\xda!" => 'U', "!\xfa!" => 'u', "!\xdb!" => 'U', "!\xfb!" => 'u', "!\xdc!" => 'U', "!\xfc!" => 'u', "!\xc7!" => 'C', "!\xe7!" => 'c', "!\xd1!" => 'N', "!\xf1!" => 'n', "!\xdf!" => 'ss' ); $find = array_keys($aHighAscii); $replace = array_values($aHighAscii); $s = preg_replace($find, $replace, $s); return $s; } function to7bit($text) { if (!function_exists('mb_convert_encoding')) { return $text; } $text = mb_convert_encoding($text,'HTML-ENTITIES',mb_detect_encoding($text)); $text = preg_replace( array('/&szlig;/','/&(..)lig;/', '/&([aouAOU])uml;/','/&(.)[^;]*;/'), array('ss',"$1","$1".'e',"$1"), $text); return $text; } function replaceAccents($str) { if (!SGL_String::isCyrillic($str)) { $str = SGL_String::to7bit($str); $str = preg_replace('/[^A-Z^a-z^0-9()]+/',' ',$str); } return $str; } function isCyrillic($str) { $ret = false; if (function_exists('mb_convert_encoding') && !empty($str)) { $aCodes = range(1040, 1103); $encoded = mb_convert_encoding($str, 'HTML-ENTITIES', mb_detect_encoding($str)); $aChars = explode(';', str_replace('&#', '', $encoded)); array_pop($aChars); $aChars = array_unique($aChars); $aNonCyrillicChars = array_diff($aChars, $aCodes); $ret = count($aNonCyrillicChars) != count($aChars); } return $ret; } function stripIniFileIllegalChars($string) { return preg_replace("/[\|\&\~\!\"\(\)]/i", "", $string); } function pseudoConstantToInt($string) { $ret = 0; if (is_int($string)) { $ret = $string; } if (is_numeric($string)) { $ret = (int)$string; } if (SGL_Inflector::isConstant($string)) { $const = str_replace("'", '', $string); if (defined($const)) { $ret = constant($const); } } return $ret; } } if (!function_exists('array_combine')) { function array_combine($a, $b) { $c = array(); if (is_array($a) && is_array($b)) while (list(, $va) = each($a)) if (list(, $vb) = each($b)) { $c[$va] = $vb; } else { break 1; } return $c; } } ?>
<?php
 class SGL_Task_Init extends SGL_DecorateProcess { function process(&$input, &$output) { if (SGL_PROFILING_ENABLED && function_exists('apd_set_pprof_trace')) { apd_set_pprof_trace(); } if (SGL_Config::get('site.outputBuffering')) { ob_start(); } $this->processRequest->process($input, $output); } } class SGL_Task_SetupORM extends SGL_DecorateProcess { function process(&$input, &$output) { $oTask = new SGL_Task_InitialiseDbDataObject(); $ok = $oTask->run(); $this->processRequest->process($input, $output); } } class SGL_Task_DetectBlackListing extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (SGL_Config::get('site.banIpEnabled')) { if (SGL_Config::get('site.allowList')) { $allowList = explode( ' ', SGL_Config::get('site.allowList')); if (!in_array($_SERVER['REMOTE_ADDR'], $allowList)) { $msg = SGL_String::translate('You have been banned'); SGL::raiseError($msg, SGL_ERROR_BANNEDUSER, PEAR_ERROR_DIE); } } if (SGL_Config::get('site.denyList')) { $denyList = explode( ' ', SGL_Config::get('site.denyList')); if (in_array($_SERVER['REMOTE_ADDR'], $denyList)) { $msg = SGL_String::translate('You have been banned'); SGL::raiseError($msg, SGL_ERROR_BANNEDUSER, PEAR_ERROR_DIE); } } } $this->processRequest->process($input, $output); } } class SGL_Task_MaintenanceModeIntercept extends SGL_DecorateProcess { function process(&$input, &$output) { if (SGL_Config::get('site.maintenanceMode')) { $rid = SGL_Session::getRoleId(); $adminMode = SGL_Session::get('adminMode'); if ($rid != SGL_ADMIN && !$adminMode && !SGL::runningFromCLI()) { $req = $input->getRequest(); if ($req->getType() == SGL_REQUEST_BROWSER) { SGL::displayMaintenancePage($output); } } } $this->processRequest->process($input, $output); } } class SGL_Task_DetectAdminMode extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $req = SGL_Request::singleton(); $adminKey = $req->get('adminKey'); if (SGL_Config::get('site.adminKey') && $adminKey == SGL_Config::get('site.adminKey')) { SGL_Session::set('adminMode', true); } $this->processRequest->process($input, $output); } } class SGL_Task_DetectSessionDebug extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $adminMode = SGL_Session::get('adminMode'); $req = $input->getRequest(); if (!$adminMode && SGL_Config::get('debug.sessionDebugAllowed') && $req->get('action') != 'rebuildSeagull' && $req->getManagerName() != 'config') { SGL_Config::set('debug.sessionDebugAllowed', false); } $this->processRequest->process($input, $output); } } class SGL_Task_SetupLocale extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $locale = $_SESSION['aPrefs']['locale']; $timezone = $_SESSION['aPrefs']['timezone']; $language = substr($locale, 0,2); if (!SGL_Config::get('site.extendedLocale')) { if (setlocale(SGL_String::pseudoConstantToInt(SGL_Config::get('site.localeCategory')), $locale) == false) { setlocale(LC_TIME, $locale); } @putenv('TZ=' . $timezone); if (strtoupper(substr(PHP_OS, 0,3)) === 'WIN') { @putenv('LANG=' . $language); @putenv('LANGUAGE=' . $language); } else { @putenv('LANG=' . $locale); @putenv('LANGUAGE=' . $locale); } } else { require_once dirname(__FILE__) . '/../Locale.php'; $setlocale = & SGL_Locale::singleton($locale); } $this->processRequest->process($input, $output); } } class SGL_Task_BuildHeaders extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); $currentMgr = SGL_Inflector::caseFix(get_class($output->manager)); $c = &SGL_Config::singleton(); $conf = $c->getAll(); if (!isset($conf[$currentMgr]['setHeaders']) || $conf[$currentMgr]['setHeaders'] == true) { @ini_set('zlib.output_compression', (int)SGL_Config::get('site.compression')); if (SGL_Config::get('p3p.policies')) { $p3pHeader = ''; if (SGL_Config::get('p3p.policyLocation')) { $p3pHeader .= " policyref=\"" . SGL_Config::get('p3p.policyLocation')."\""; } if (SGL_Config::get('p3p.compactPolicy')) { $p3pHeader .= " CP=\"" . SGL_Config::get('p3p.compactPolicy')."\""; } if ($p3pHeader != '') { header("P3P: $p3pHeader"); } } header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT'); header('Content-Type: text/html; charset=' . $GLOBALS['_SGL']['CHARSET']); header('X-Powered-By: Seagull http://seagullproject.org'); foreach ($output->getHeaders() as $header) { header($header); } } } } class SGL_Task_AuthenticateRequest extends SGL_DecorateProcess { function getRememberMeCookieData() { if (!isset($_COOKIE['SGL_REMEMBER_ME'])) { return false; } $cookie = $_COOKIE['SGL_REMEMBER_ME']; list($username, $cookieValue) = @unserialize($cookie); if (!$username || !$cookieValue) { return false; } require_once SGL_MOD_DIR . '/user/classes/UserDAO.php'; $da = &UserDAO::singleton(); $uid = $da->getUserIdByCookie($username, $cookieValue); if ($uid) { $ret = array('uid' => $uid, 'cookieVal' => $cookieValue); } else { $ret = false; } return $ret; } function doLogin($uid, &$input) { $input->set('session', new SGL_Session($uid, $rememberMe = true)); require_once SGL_MOD_DIR . '/user/classes/observers/RecordLogin.php'; if (RecordLogin::loginRecordingAllowed()) { $dbh = &SGL_DB::singleton(); RecordLogin::insert($dbh); } } function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $session = $input->get('session'); $timeout = !$session->updateIdle(); $aRequestHistory = SGL_Session::get('aRequestHistory'); if (empty($aRequestHistory)) { $aRequestHistory = array(); } $req = $input->getRequest(); array_unshift($aRequestHistory, $req->getAll()); $aTruncated = array_slice($aRequestHistory, 0, 2); SGL_Session::set('aRequestHistory', $aTruncated); $mgr = $input->get('manager'); $mgrName = SGL_Inflector::caseFix(get_class($mgr)); if (($session->isAnonymous() || $timeout) && SGL_Config::get('cookie.rememberMeEnabled') && !SGL_Config::get('site.maintenanceMode')) { $aCookieData = $this->getRememberMeCookieData(); if (!empty($aCookieData['uid'])) { $this->doLogin($aCookieData['uid'], $input); $session = $input->get('session'); $timeout = !$session->updateIdle(); } } if ( SGL_Config::get("$mgrName.requiresAuth") && SGL_Config::get('debug.authorisationEnabled') && !SGL::runningFromCLI()) { if (!$session->isValid() || $timeout) { $url = $input->getCurrentUrl(); $redir = $url->toString(); $loginPage = array( 'moduleName' => 'user', 'managerName' => 'login', 'redir' => base64_encode($redir) ); if (!$session->isValid()) { SGL::raiseMsg('authentication required'); SGL_HTTP::redirect($loginPage); } else { $session->destroy(); SGL::raiseMsg('session timeout'); SGL_HTTP::redirect($loginPage); } } } $this->processRequest->process($input, $output); } } class SGL_Task_SetupPerms extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $cache = & SGL_Cache::singleton(); if ($serialized = $cache->get('all_users', 'perms')) { $aPerms = unserialize($serialized); SGL::logMessage('perms from cache', PEAR_LOG_DEBUG); } else { require_once SGL_MOD_DIR . '/user/classes/UserDAO.php'; $da = & UserDAO::singleton(); $aPerms = $da->getPermsByModuleId(); $serialized = serialize($aPerms); $cache->save($serialized, 'all_users', 'perms'); SGL::logMessage('perms from db', PEAR_LOG_DEBUG); } if (is_array($aPerms) && count($aPerms)) { foreach ($aPerms as $k => $v) { define('SGL_PERMS_' . strtoupper($v), $k); } } else { SGL::raiseError('there was a problem initialising perms', SGL_ERROR_NODATA); } $this->processRequest->process($input, $output); } } class SGL_Task_SetupLangSupport extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $_SESSION['aPrefs']['language'] = $lang = $this->_resolveLanguage(); $output->rvLang = $this->_rvLanguage(); $req = $input->getRequest(); $aLanguages = $GLOBALS['_SGL']['LANGUAGE']; if (isset($aLanguages[$lang][3])) { $_SESSION['aPrefs']['locale'] = $aLanguages[$lang][3]; } if (SGL_Config::get('translation.defaultLangBC')) { $moduleDefault = 'default'; } else { $moduleDefault = SGL_Config::get('site.defaultModule'); } $moduleCurrent = $req->get('moduleName') ? $req->get('moduleName') : $moduleDefault; $aWords = SGL_Translation::getTranslations($moduleDefault, $lang); if ($moduleCurrent != $moduleDefault) { $aWords = array_merge( $aWords, SGL_Translation::getTranslations($moduleCurrent, $lang) ); } $GLOBALS['_SGL']['TRANSLATION'] = $aWords; $GLOBALS['_SGL']['CHARSET'] = SGL_Translation::getCharset(); $this->processRequest->process($input, $output); } function resolveLanguageFromBrowser() { $ret = false; if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) { $env = $_SERVER['HTTP_ACCEPT_LANGUAGE']; $aLangs = preg_split( ';[\s,]+;', substr($env, 0, strpos($env . ';', ';')), -1, PREG_SPLIT_NO_EMPTY ); foreach ($aLangs as $langCode) { $lang = $langCode . '-' . SGL_Translation::getFallbackCharset(); if (SGL_Translation::isAllowedLanguage($lang)) { $ret = $lang; break; } } } return $ret; } function resolveLanguageFromDomain() { $ret = false; if (isset($_SERVER['HTTP_HOST'])) { $langCode = array_pop(explode('.', $_SERVER['HTTP_HOST'])); $lang = $langCode . '-' . SGL_Translation::getFallbackCharset(); if (SGL_Translation::isAllowedLanguage($lang)) { $ret = $lang; } } return $ret; } function _resolveLanguage() { $req = &SGL_Request::singleton(); $lang = $req->get('lang'); $anonRequest = SGL_Session::isFirstAnonRequest(); if (empty($lang) || !SGL_Translation::isAllowedLanguage($lang)) { if (!isset($_SESSION['aPrefs']['language']) || !SGL_Translation::isAllowedLanguage($_SESSION['aPrefs']['language']) || $anonRequest) { if (!SGL_Config::get('translation.languageAutoDiscover') || !($lang = $this->resolveLanguageFromBrowser())) { if (!SGL_Config::get('translation.languageAutoDiscover') || !($lang = $this->resolveLanguageFromDomain())) { $lang = SGL_Translation::getFallbackLangID(SGL_LANG_ID_SGL); } } } else { $lang = $_SESSION['aPrefs']['language']; } } return $lang; } function _rvLanguage() { $componentLang = array(); $lang = $_SESSION['aPrefs']['language']; $dbh = &SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $query = "
                SELECT `name`
                FROM {$conf['table']['module']}
                WHERE name LIKE '%web' 
            "; $aModuleWeb = $dbh->getAll($query, DB_FETCHMODE_ASSOC); require_once(SGL_MOD_DIR . '/main/classes/Main.php'); $oMain = new Main; for ($i=0;$i<count($aModuleWeb);$i++) { $componentName = $aModuleWeb[$i]['name']; $getLangMap = $oMain->languageMap($componentName, $lang); if ($getLangMap != false) { $componentLang[$componentName] = $getLangMap; } } return $componentLang; } } class SGL_Task_CreateSession extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $input->set('session', new SGL_Session()); $this->processRequest->process($input, $output); } } class SGL_Task_ResolveManager extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $req = $input->getRequest(); $moduleName = $req->get('moduleName'); $managerName = $req->get('managerName'); $getDefaultMgr = false; if (empty($moduleName) || empty($managerName)) { SGL::logMessage('Module and manager names could not be determined from request'); $getDefaultMgr = true; } else { if (!SGL::moduleIsEnabled($moduleName)) { SGL::raiseError('module "'.$moduleName.'" does not appear to be registered', SGL_ERROR_RESOURCENOTFOUND); $getDefaultMgr = true; } else { $conf = $input->getConfig(); $mgrPath = SGL_MOD_DIR . '/' . $moduleName . '/classes/'; $retMgrName = $this->getManagerName($managerName, $mgrPath, $conf); if ($retMgrName === false) { SGL::raiseError("Specified manager '$managerName' could not be found, ". "defaults loaded, pls ensure full manager name is present in module's conf.ini", SGL_ERROR_RESOURCENOTFOUND); } $managerName = ($retMgrName) ? $retMgrName : $this->getManagerName($moduleName, $mgrPath, $conf); if (!empty($managerName)) { $classPath = $mgrPath . $managerName . '.php'; if (@is_file($classPath)) { require_once $classPath; if (@class_exists($managerName)) { $input->moduleName = $moduleName; $input->set('manager', new $managerName); } else { SGL::logMessage("Class $managerName does not exist"); $getDefaultMgr = true; } } else { SGL::logMessage("Could not find file $classPath"); $getDefaultMgr = true; } } else { SGL::logMessage('Manager name could not be determined from '. 'SGL_Process_ResolveManager::getManagerName'); $getDefaultMgr = true; } } } if ($getDefaultMgr) { $ok = $this->getConfiguredDefaultManager($input); if (!$ok) { SGL::raiseError("The default manager could not be found", SGL_ERROR_RESOURCENOTFOUND); $this->getDefaultManager($input); } } $this->processRequest->process($input, $output); } function getConfiguredDefaultManager(&$input) { $defaultModule = SGL_Config::get('site.defaultModule'); $defaultMgr = SGL_Config::get('site.defaultManager'); $c = &SGL_Config::singleton(); $conf = $c->ensureModuleConfigLoaded($defaultModule); if (PEAR::isError($conf)) { SGL::raiseError('could not locate module\'s config file', SGL_ERROR_NOFILE); return false; } $mgrName = SGL_Inflector::caseFix( SGL_Inflector::getManagerNameFromSimplifiedName($defaultMgr)); $path = SGL_MOD_DIR .'/'.$defaultModule.'/classes/'.$mgrName.'.php'; if (!is_file($path)) { SGL::raiseError('could not locate default manager, '.$path, SGL_ERROR_NOFILE); return false; } require_once $path; if (!class_exists($mgrName)) { SGL::raiseError('invalid class name for default manager', SGL_ERROR_NOCLASS); return false; } $mgr = new $mgrName(); $input->moduleName = $defaultModule; $input->set('manager', $mgr); $req = $input->getRequest(); $req->set('moduleName', $defaultModule); $req->set('managerName', $defaultMgr); if (SGL_Config::get('site.defaultParams')) { $aParams = SGL_Url::querystringArrayToHash( explode('/', SGL_Config::get('site.defaultParams'))); $req->add($aParams); } $input->setRequest($req); return true; } function getDefaultManager(&$input) { $defaultModule = 'default'; $defaultMgr = 'default'; $mgrName = SGL_Inflector::caseFix( SGL_Inflector::getManagerNameFromSimplifiedName($defaultMgr)); $path = SGL_MOD_DIR .'/'.$defaultModule.'/classes/'.$mgrName.'.php'; require_once $path; $mgr = new $mgrName(); $input->moduleName = $defaultModule; $input->set('manager', $mgr); $req = $input->getRequest(); $req->set('moduleName', $defaultModule); $req->set('managerName', $defaultMgr); $input->setRequest($req); return true; } function getManagerName($managerName, $path, $conf) { SGL::logMessage(null, PEAR_LOG_DEBUG); $aMatches = array(); $aConfValues = array_keys($conf); $aConfValuesLowerCase = array_map('strtolower', $aConfValues); $managerName = SGL_Inflector::getManagerNameFromSimplifiedName($managerName); $isFound = array_search($managerName, $aConfValues); if ($isFound !== false) { $aMatches['caseSensitiveMgrName'] = $aConfValues[$isFound]; } unset($isFound); $isFound = array_search(strtolower($managerName), $aConfValuesLowerCase); if ($isFound !== false) { $aMatches['caseInSensitiveMgrName'] = $aConfValues[$isFound]; } foreach ($aMatches as $match) { if (!@is_file($path . $match . '.php')) { continue; } else { return $match; } } return false; } } class SGL_Task_StripMagicQuotes extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); $req = $input->getRequest(); SGL_String::dispelMagicQuotes($req->aProps); $input->setRequest($req); $this->processRequest->process($input, $output); } } class SGL_Task_DiscoverClientOs extends SGL_DecorateProcess { function process(&$input, &$output) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (isset($_SERVER['HTTP_USER_AGENT'])) { $ua = $_SERVER['HTTP_USER_AGENT']; } else { $ua = ''; } if (!empty($ua) and !defined('SGL_CLIENT_OS')) { if (strstr($ua, 'Win')) { define('SGL_CLIENT_OS', 'Win'); } elseif (strstr($ua, 'Mac')) { define('SGL_CLIENT_OS', 'Mac'); } elseif (strstr($ua, 'Linux')) { define('SGL_CLIENT_OS', 'Linux'); } elseif (strstr($ua, 'Unix')) { define('SGL_CLIENT_OS', 'Unix'); } elseif (strstr($ua, 'OS/2')) { define('SGL_CLIENT_OS', 'OS/2'); } else { define('SGL_CLIENT_OS', 'Other'); } } else { if (!defined('SGL_CLIENT_OS')) { define('SGL_CLIENT_OS', 'None'); } } $this->processRequest->process($input, $output); } } class SGL_Task_BuildOutputData extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); SGL_Task_BuildOutputData::addOutputData($output); } function addOutputData(&$output) { if (SGL_Session::getRoleId() > SGL_GUEST) { $output->loggedOnUser = SGL_Session::getUsername(); $output->loggedOnUserID = SGL_Session::getUid(); $output->loggedOnSince = strftime("%H:%M:%S", SGL_Session::get('startTime')); $output->loggedOnDate = strftime("%B %d", SGL_Session::get('startTime')); $output->isMember = true; } if (!SGL::runningFromCLI()) { $output->remoteIp = $_SERVER['REMOTE_ADDR']; $output->currUrl = SGL_Config::get('site.inputUrlHandlers') == 'Horde_Routes' ? SGL_Task_BuildOutputData::getCurrentUrlFromRoutes() : $_SERVER['PHP_SELF']; } $output->currUrl = $_SERVER['PHP_SELF']; $output->currLang = (defined('RVS_AUTO_SETUP')) ? RVSCOMPODB::getCurrentLang() : SGL::getCurrentLang(); $output->currFullLang = $_SESSION['aPrefs']['language']; $output->langDir = ($output->currLang == 'ar' || $output->currLang == 'he') ? 'rtl' : 'ltr'; $output->theme = isset($_SESSION['aPrefs']['theme']) ? $_SESSION['aPrefs']['theme'] : 'default'; if (isset($output->manager)) { $mgrName = SGL_Inflector::caseFix(get_class($output->manager)); if (SGL_Config::get("$mgrName.theme")) { $output->theme = SGL_Config::get("$mgrName.theme"); } } $output->charset = (defined('RVS_AUTO_SETUP')) ? RVSCOMPODB::getCurrentCharset() : $GLOBALS['_SGL']['CHARSET']; $c = &SGL_Config::singleton(); $output->conf = $c->getAll(); $output->webRoot = SGL_BASE_URL; $output->imagesDir = SGL_BASE_URL . '/themes/' . $output->theme . '/images'; $output->versionAPI = SGL_SEAGULL_VERSION; $output->sessID = SGL_Session::getId(); $output->isMinimalInstall = SGL::isMinimalInstall(); $output->scriptOpen = "\n<script type='text/javascript'>\n//<![CDATA[\n"; $output->scriptClose = "\n//]]>\n</script>\n"; $output->showExecutionTimes = $_SESSION['aPrefs']['showExecutionTimes']; } function getCurrentUrlFromRoutes() { $input = &SGL_Registry::singleton(); $url = $input->getCurrentUrl(); $currUrl = $url->toString(); $baseUrl = $url->getBaseUrl($skipProto = false, $includeFc = false); return str_replace($baseUrl, '', $currUrl); } } class SGL_Task_SetupWysiwyg extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); if (isset($output->wysiwyg) && $output->wysiwyg == true && !SGL::runningFromCLI()) { if (!isset($output->wysiwygEditor)) { $output->wysiwygEditor = SGL_Config::get('site.wysiwygEditor') ? SGL_Config::get('site.wysiwygEditor') : 'fck'; } switch ($output->wysiwygEditor) { case 'fck': case 'fckeditor': $output->wysiwyg_fck = true; $output->addOnLoadEvent('fck_init()'); break; case 'xinha': $output->wysiwyg_xinha = true; $output->addOnLoadEvent('xinha_init()'); break; case 'htmlarea': $output->wysiwyg_htmlarea = true; $output->addOnLoadEvent('HTMLArea.init()'); break; case 'tinyfck': $output->wysiwyg_tinyfck = true; break; } } } } class SGL_Task_SetupNavigation extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); if (SGL_Config::get('navigation.enabled') && !SGL::runningFromCli()) { $navDriver = SGL_Config::get('navigation.driver'); $navDrvFile = SGL_MOD_DIR . '/navigation/classes/' . $navDriver . '.php'; if (is_file($navDrvFile)) { require_once $navDrvFile; } else { return SGL::raiseError("specified navigation driver, $navDrvFile, does not exist", SGL_ERROR_NOFILE); } if (!class_exists($navDriver)) { return SGL::raiseError('problem with navigation driver object', SGL_ERROR_NOCLASS); } $nav = & new $navDriver($output); $navRenderer = SGL_Config::get('navigation.renderer'); $aRes = $nav->render($navRenderer); if (!PEAR::isError($aRes)) { list($sectionId, $html) = $aRes; $output->sectionId = $sectionId; $output->navigation = $html; $output->currentSectionName = $nav->getCurrentSectionName(); } } } } class SGL_Task_SetupGui extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); if (!SGL::runningFromCLI()) { $mgrName = SGL_Inflector::caseFix(get_class($output->manager)); $adminGuiAllowed = $adminGuiRequested = false; $output->adminGuiAllowed = false; if (SGL_Session::hasAdminGui()) { $adminGuiAllowed = true; } $c = &SGL_Config::singleton(); $conf = $c->getAll(); if (!$c->get($mgrName)) { $req = &SGL_Request::singleton(); $moduleName = $req->getModuleName(); $conf = $c->ensureModuleConfigLoaded($moduleName); if (PEAR::isError($conf)) { SGL::raiseError('could not locate module\'s config file', SGL_ERROR_NOFILE); } } if (isset( $conf[$mgrName]['adminGuiAllowed']) && $conf[$mgrName]['adminGuiAllowed']) { $adminGuiRequested = true; if (isset($output->overrideAdminGuiAllowed) && $output->overrideAdminGuiAllowed) { $adminGuiRequested = false; } } if ($adminGuiAllowed && $adminGuiRequested) { $output->adminGuiAllowed = true; $output->theme = $conf['site']['adminGuiTheme']; $output->masterTemplate = 'admin_master.html'; $output->template = 'admin_' . $output->template; if (isset($output->submitted) && $output->submitted) { $output->addOnLoadEvent("formErrorCheck()"); } } } } } class SGL_Task_SetupBlocks extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); if (SGL_Config::get('site.blocksEnabled') && !SGL::runningFromCli()) { $output->sectionId = empty($output->sectionId) ? 0 : $output->sectionId; $blockLoader = & new SGL_BlockLoader($output->sectionId); $aBlocks = $blockLoader->render($output); foreach ($aBlocks as $key => $value) { $blocksName = 'blocks'.$key; $output->$blocksName = $value; } } } } class SGL_Task_BuildDebugBlock extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); if (SGL_Config::get('debug.infoBlock')) { $output->debug_request = $output->request; $output->debug_session = $_SESSION; $output->debug_module = $output->moduleName; $output->debug_manager = isset($output->managerName) ? $output->managerName : ''; $output->debug_action = $output->action; $output->debug_section = $output->sectionId; $output->debug_master_template = isset($output->masterTemplate) ? $output->masterTemplate : ''; $output->debug_template = $output->template; $output->debug_theme = $output->theme; } } } class SGL_Task_BuildView extends SGL_DecorateProcess { function process(&$input, &$output) { $this->processRequest->process($input, $output); SGL::logMessage(null, PEAR_LOG_DEBUG); $output->onLoad = $output->getOnLoadEvents(); $output->onUnload = $output->getOnUnloadEvents(); $output->onReadyDom = $output->getOnReadyDomEvents(); $output->javascriptSrc = $output->getJavascriptFiles(); unset($output->currentUrl); unset($output->manager->conf); unset($output->manager->dbh); $templateEngine = isset($output->templateEngine) ? $output->templateEngine : null; $view = new SGL_HtmlSimpleView($output, $templateEngine); $output->data = $view->render(); } } class SGL_Void extends SGL_ProcessRequest { function process(&$input) { SGL::logMessage(null, PEAR_LOG_DEBUG); } } ?>
<?php
 define('SGL_SESSION_UPDATE_WINDOW', 10); class SGL_Session { var $_timeout; function SGL_Session($uid = -1, $rememberMe = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $sessName = isset($conf['cookie']['name']) ? $conf['cookie']['name'] : 'SGLSESSID'; session_name($sessName); session_set_cookie_params( 0, $conf['cookie']['path'], $conf['cookie']['domain'], $conf['cookie']['secure']); if ($conf['session']['handler'] == 'database') { $ok = session_set_save_handler( array(& $this, 'dbOpen'), array(& $this, 'dbClose'), array(& $this, 'dbRead'), array(& $this, 'dbWrite'), array(& $this, 'dbDestroy'), array(& $this, 'dbGc') ); } else { session_save_path(SGL_TMP_DIR); } @session_start(); if ($uid > 0) { require_once 'DB/DataObject.php'; $sessUser = DB_DataObject::factory($conf['table']['user']); $sessUser->get($uid); $this->_init($sessUser, $rememberMe); if ($rememberMe) { $this->setRememberMeCookie(); } } elseif (!SGL_Session::exists()) { $this->_init(); } } function setRememberMeCookie() { SGL::logMessage(null, PEAR_LOG_DEBUG); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $cookie = serialize(array($_SESSION['username'], $_SESSION['cookie'])); $ok = setcookie( 'SGL_REMEMBER_ME', $cookie, time() + 31104000, $conf['cookie']['path'], $conf['cookie']['domain'], $conf['cookie']['secure'] ); } function _init($oUser = null, $rememberMe = null) { SGL::logMessage(null, PEAR_LOG_DEBUG); require_once SGL_MOD_DIR . '/user/classes/UserDAO.php'; $da = & UserDAO::singleton(); $startTime = mktime(); $acceptLang = @$_SERVER['HTTP_ACCEPT_LANGUAGE']; $userAgent = @$_SERVER['HTTP_USER_AGENT']; if (is_object($oUser)) { $aSessVars = array( 'uid' => $oUser->usr_id, 'rid' => $oUser->role_id, 'username' => $oUser->username, 'startTime' => $startTime, 'lastRefreshed' => $startTime, 'key' => md5($oUser->username . $startTime . $acceptLang . $userAgent), 'aPrefs' => $da->getPrefsByUserId($oUser->usr_id, $oUser->role_id) ); if ($oUser->role_id == SGL_ADMIN) { $aPerms = array(); } elseif (($method = SGL_Config::get('session.permsRetrievalMethod')) && is_callable(array($da, $method))) { $aPerms = $da->$method($oUser); } else { $aPerms = $da->getPermsByUserId($oUser->usr_id); } $aSessVars['aPerms'] = $aPerms; list(, $cookieValue) = @unserialize($_COOKIE['SGL_REMEMBER_ME']); if (!empty($cookieValue)) { $da->deleteUserLoginCookieByUserId($oUser->usr_id, $cookieValue); } if (!empty($rememberMe)) { $salt = 'SGL_SALT'; $cookieValue = md5($salt . $aSessVars['key']); $da->addUserLoginCookie($oUser->usr_id, $cookieValue); $aSessVars['cookie'] = $cookieValue; } } else { $aSessVars = array( 'uid' => 0, 'rid' => 0, 'username' => 'guest', 'startTime' => $startTime, 'lastRefreshed' => $startTime, 'key' => md5($startTime . $acceptLang . $userAgent), 'currentResRange' => 'all', 'sortOrder' => 'ASC', 'aPrefs' => $da->getPrefsByUserId(), 'aPerms' => $da->getPermsByRoleId(), ); } if (SGL_Config::get('OrgMgr.enabled')) { $aSessVars['oid'] = !empty($oUser->organisation_id) ? $oUser->organisation_id : 0; } if (isset($_SESSION)) { foreach ($aSessVars as $k => $v) { $_SESSION[$k] = $v; } } if (function_exists('session_regenerate_id')) { $c = &SGL_Config::singleton(); $conf = $c->getAll(); $oldSessionId = session_id(); @session_regenerate_id(); if ($conf['session']['handler'] == 'file') { $ok = @unlink(SGL_TMP_DIR . '/sess_'.$oldSessionId); } elseif ($conf['session']['handler'] == 'database') { $value = $this->dbRead($oldSessionId); $this->dbDestroy($oldSessionId); $this->dbRead(session_id()); $this->dbWrite(session_id(), $value); } else { die('Internal Error: unknown session handler'); } } return true; } function exists() { SGL::logMessage(null, PEAR_LOG_DEBUG); return isset($_SESSION) && count($_SESSION); } function isValid() { SGL::logMessage(null, PEAR_LOG_DEBUG); $acceptLang = @$_SERVER['HTTP_ACCEPT_LANGUAGE']; $userAgent = @$_SERVER['HTTP_USER_AGENT']; $currentKey = md5($_SESSION['username'] . $_SESSION['startTime'] . $acceptLang . $userAgent); return ($currentKey == $_SESSION['key']); } function isAnonymous() { $ret = !((bool) $_SESSION['uid']); return $ret; } function runAs($runAs, $direction = null) { $aStack = SGL_Session::get('sessionStack'); if (!is_array($aStack)) { $aStack = array(); } if (is_numeric($runAs) && empty($direction)) { array_push($aStack, SGL_Session::getUid()); } elseif ($runAs == 'prev') { $runAs = array_pop($aStack); } else { do { $userId = array_pop($aStack); } while ($userId != $runAs && !is_null($userId)); } SGL_Session::set('sessionStack', $aStack); new SGL_Session($runAs); } function isTimedOut() { SGL::logMessage(null, PEAR_LOG_DEBUG); $currentTime = mktime(); $lastPageRefreshTime = $_SESSION['lastRefreshed']; $timeout = isset($_SESSION['aPrefs']['sessionTimeout']) ? $_SESSION['aPrefs']['sessionTimeout'] : ''; if (empty($timeout)) { return false; } if ($currentTime - $lastPageRefreshTime > $timeout) { return true; } else { return false; } } function updateIdle() { SGL::logMessage(null, PEAR_LOG_DEBUG); $ret = false; if (!$this->isTimedOut()) { if (mktime() - $_SESSION['lastRefreshed'] > SGL_SESSION_UPDATE_WINDOW ) { $_SESSION['lastRefreshed'] = mktime(); } $ret = true; } return $ret; } function hasPerms($permId) { if (!isset($_SESSION) || !count($_SESSION)) { return false; } if (@$_SESSION['rid'] == SGL_ADMIN) { $ret = true; } else { if (is_array($_SESSION['aPerms'])) { $ret = in_array($permId, $_SESSION['aPerms']); } else { $ret = false; } } return $ret; } function currentUserIsOwner($ownerId) { if (!isset($_SESSION)) { return false; } return $_SESSION['uid'] == $ownerId; } function hasAdminGui() { $aRoles = explode(',', SGL_Config::get('site.rolesHaveAdminGui')); foreach ($aRoles as $k => $role) { $aRoles[$k] = SGL_String::pseudoConstantToInt($role); } if (!in_array(SGL_ADMIN, $aRoles)) { $aRoles[] = SGL_ADMIN; } if (!isset($_SESSION['rid'])) { $ret = false; } else { $ret = in_array($_SESSION['rid'], $aRoles); } return $ret; } function getUid() { SGL::logMessage(null, PEAR_LOG_DEBUG); if (count($_SESSION && isset($_SESSION['uid']))) { return $_SESSION['uid']; } else { return false; } } function getUsername() { SGL::logMessage(null, PEAR_LOG_DEBUG); if (count($_SESSION && isset($_SESSION['username']))) { return $_SESSION['username']; } else { return false; } } function getRoleId() { SGL::logMessage(null, PEAR_LOG_DEBUG); if (isset($_SESSION) && count($_SESSION) && isset($_SESSION['rid'])) { return $_SESSION['rid']; } else { return false; } } function getOrganisationId() { SGL::logMessage(null, PEAR_LOG_DEBUG); if (count($_SESSION) && isset($_SESSION['oid'])) { return $_SESSION['oid']; } else { return false; } } function remove($sessVarName) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (isset($sessVarName)) { unset($_SESSION[$sessVarName]); return true; } else { return false; } } function get($sessVarName) { if (isset($sessVarName) && isset($_SESSION)) { return is_array($_SESSION) ? (array_key_exists($sessVarName, $_SESSION) ? $_SESSION[$sessVarName] : '') : ''; } else { return null; } } function set($sessVarName, $sessVarValue) { $_SESSION[$sessVarName] = $sessVarValue; } function debug() { SGL::logMessage(null, PEAR_LOG_DEBUG); $ret = ''; foreach ($_SESSION as $sessVarName => $sessVarValue) { $ret .= "$sessVarName => $sessVarValue<br />\n"; } return $ret; } function getId() { $c = &SGL_Config::singleton(); $conf = $c->getAll(); return defined('SID') && SID !='' ? SID : $conf['cookie']['name'] . '='. session_id(); } function destroy() { SGL::logMessage(null, PEAR_LOG_DEBUG); $c = &SGL_Config::singleton(); $conf = $c->getAll(); foreach ($_SESSION as $sessVarName => $sessVarValue) { if (isset($_SESSION)) { unset($sessVarName); } } @session_destroy(); $_SESSION = array(); setcookie( $conf['cookie']['name'], null, 0, $conf['cookie']['path'], $conf['cookie']['domain'], $conf['cookie']['secure']); if (!empty($conf['cookie']['rememberMeEnabled'])) { $ok = setcookie('SGL_REMEMBER_ME', null, 0, $conf['cookie']['path'], $conf['cookie']['domain'], $conf['cookie']['secure']); } $sess = & new SGL_Session(); } function getUserSessionCount($uid, $sessId = -1) { $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); if ($sessId == -1) { $query = "SELECT count(*) FROM {$conf['table']['user_session']} WHERE usr_id = $uid"; } else { $query = "
                SELECT count(*)
                FROM {$conf['table']['user_session']}
                WHERE usr_id = $uid
                AND session_id != '$sessId'"; } $res = $dbh->getOne($query); return $res; } function destroyUserSessions($uid, $sessId = -1) { SGL::logMessage(null, PEAR_LOG_DEBUG); $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); if ($sessId == -1) { $query = "DELETE FROM {$conf['table']['user_session']} WHERE usr_id = $uid"; } else { $query = "
                DELETE FROM {$conf['table']['user_session']}
                WHERE usr_id = $uid AND session_id != '$sessId'"; } $dbh->query($query); } function getGuestSessionCount() { $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $query = "SELECT count(*) FROM {$conf['table']['user_session']} WHERE username = 'guest'"; $res = $dbh->getOne($query); return $res; } function getMemberSessionCount() { $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $query = "SELECT count(*) FROM {$conf['table']['user_session']} WHERE username != 'guest'"; $res = $dbh->getOne($query); return $res; } function getSessionCount() { $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $query = "SELECT count(*) FROM {$conf['table']['user_session']}"; $res = $dbh->getOne($query); return $res; } function dbOpen() { $timeout = isset($_SESSION['aPrefs']['sessionTimeout']) ? $_SESSION['aPrefs']['sessionTimeout'] : 900; $this->dbGc($timeout); return true; } function dbClose() { return true; } function dbRead($sessId) { $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $user_session = $conf['table']['user_session']; $query = "SELECT data_value FROM {$user_session} WHERE session_id = '$sessId'"; $res = $dbh->query($query); if (PEAR::isError($res)) { return $res; } if ($res->numRows() == 1) { $sessionContent = $dbh->getOne($query); if (!defined('SGL_SESSION_DATA')) { define('SGL_SESSION_DATA', $sessionContent); } return $sessionContent; } else { $timeStamp = SGL_Date::getTime(true); if (!empty($conf['session']['extended'])) { $uid = isset($_SESSION['uid']) ? $_SESSION['uid'] : 0; $username = $_SESSION['username']; $timeout = isset($_SESSION['aPrefs']['sessionTimeout']) ? $_SESSION['aPrefs']['sessionTimeout'] : 900; $query = "
                    INSERT INTO {$user_session} (session_id, last_updated, data_value, usr_id, username, expiry)
                    VALUES ('$sessId', '$timeStamp', '', $uid, '$username', $timeout)"; } else { $query = "
                    INSERT INTO {$user_session} (session_id, last_updated, data_value)
                    VALUES ('$sessId', '$timeStamp', '')"; } $dbh->query($query); return ''; } } function dbWrite($sessId, $value) { if ($value == SGL_SESSION_DATA) { return true; } $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $timeStamp = SGL_Date::getTime(true); $qval = $dbh->quote($value); $user_session = $conf['table']['user_session']; if (!empty($conf['session']['extended'])) { $uid = isset($_SESSION['uid']) ? $_SESSION['uid'] : 0; $username = $_SESSION['username']; $timeout = isset($_SESSION['aPrefs']['sessionTimeout']) ? $_SESSION['aPrefs']['sessionTimeout'] : 900; $query = "
                UPDATE {$user_session}
                SET data_value = $qval,
                    last_updated = '$timeStamp',
                    usr_id='$uid',
                    username='$username',
                    expiry='$timeout'
                WHERE session_id = '$sessId'"; } else { $query = "
            UPDATE {$user_session}
            SET data_value = $qval,
                last_updated = '$timeStamp'
                WHERE session_id = '$sessId'"; } $res = $dbh->query($query); return true; } function dbDestroy($sessId) { $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $query = "DELETE FROM {$conf['table']['user_session']} WHERE session_id = '$sessId'"; $res = $dbh->query($query); return true; } function dbGc($max_expiry) { SGL::logMessage(null, PEAR_LOG_DEBUG); $dbh = & SGL_DB::singleton(); $c = &SGL_Config::singleton(); $conf = $c->getAll(); $timeStamp = SGL_Date::getTime(true); $user_session = $conf['table']['user_session']; if (!empty($conf['session']['extended'])) { $query = "
                DELETE  FROM {$user_session}
                WHERE   (UNIX_TIMESTAMP('$timeStamp') - UNIX_TIMESTAMP(last_updated)) > $max_expiry
                AND     (UNIX_TIMESTAMP('$timeStamp') - UNIX_TIMESTAMP(last_updated)) >  expiry"; } else { $query = "
                DELETE FROM {$user_session}
                WHERE UNIX_TIMESTAMP('$timeStamp') - UNIX_TIMESTAMP(last_updated ) > $max_expiry"; } $dbh->query($query); return true; } function isFirstAnonRequest($clean = null) { static $ret; if (!empty($clean)) { if (isset($_SESSION['isFirstAnonRequest'])) { unset($_SESSION['isFirstAnonRequest']); } if (isset($ret)) { unset($ret); } return true; } elseif (SGL_Session::getRoleId() == SGL_GUEST && !isset($ret)) { $ret = !isset($_SESSION['isFirstAnonRequest']); if (!isset($_SESSION['isFirstAnonRequest'])) { $_SESSION['isFirstAnonRequest'] = true; } return isset($ret) ? $ret : false; } } function isFirstAuthenticatedRequest($clean = null) { static $ret; if (!empty($clean)) { if (isset($_SESSION['isFirstAuthRequest'])) { unset($_SESSION['isFirstAuthRequest']); } if (isset($ret)) { unset($ret); } return true; } elseif (SGL_Session::getRoleId() > SGL_GUEST && !isset($ret)) { $ret = !isset($_SESSION['isFirstAuthRequest']); if (!isset($_SESSION['isFirstAuthRequest'])) { $_SESSION['isFirstAuthRequest'] = true; } return isset($ret) ? $ret : false; } } } ?>
<?php
 class SGL_Util { function getSortOrder($sortOrder) { SGL::logMessage(null, PEAR_LOG_DEBUG); if ($sortOrder == '') { $order = SGL_Session::get('sortOrder'); } elseif ($sortOrder == 'ASC') { $order = 'DESC'; } else { $order = 'ASC'; } SGL_Session::set('sortOrder', $order); return $order; } function getSortBy($frmSortBy, $callingPage) { SGL::logMessage(null, PEAR_LOG_DEBUG); switch ($callingPage) { case SGL_SORTBY_GRP: $sortByType = 'Grp'; $sessSortBy = SGL_Session::get('sortByGrp'); break; case SGL_SORTBY_USER: $sortByType = 'User'; $sessSortBy = SGL_Session::get('sortByUser'); break; } if ($frmSortBy == '' && $sessSortBy == '') { $sortBy = $this->sortBy; } elseif ($frmSortBy == '') { $sortBy = $sessSortBy; } else { $sortBy = $frmSortBy; } $sessVar = 'sortBy' . $sortByType; SGL_Session::set($sessVar, $sortBy); return $sortBy; } function getAllThemes() { SGL::logMessage(null, PEAR_LOG_DEBUG); require_once 'File/Util.php'; $ret = SGL_Util::listDir(SGL_THEME_DIR, FILE_LIST_DIRS, $sort = FILE_SORT_NONE, array('SGL_Util', 'themeFilterCallback')); return $ret; } function themeFilterCallback($str) { return (stristr($str, '_admin')) ? false : true; } function getAllModuleDirs($onlyRegistered = true) { SGL::logMessage(null, PEAR_LOG_DEBUG); require_once 'File/Util.php'; $ret = SGL_Util::listDir(SGL_MOD_DIR, FILE_LIST_DIRS, FILE_SORT_NAME, create_function('$a', 'return preg_match("/[^CVS]/", $a);')); foreach ($ret as $module) { if ($onlyRegistered && !SGL::moduleIsEnabled($module)) { unset($ret[$module]); } } return $ret; } function getAllManagersPerModule($moduleDir) { SGL::logMessage(null, PEAR_LOG_DEBUG); require_once 'File/Util.php'; $classDir = $moduleDir . '/classes'; $ret = SGL_Util::listDir($classDir, FILE_LIST_FILES, $sort = FILE_SORT_NAME, create_function('$a', 'return preg_match("/.*Mgr\.php$/", $a);')); array_walk($ret, create_function('&$a', 'preg_match("/^.*Mgr/", $a, $matches); $a =  $matches[0]; return true;')); return $ret; } function getAllActionMethodsPerMgr($mgr) { $managerFileName = basename($mgr); $moduleDir = dirname(dirname($mgr)); $files = SGL_Util::getAllManagersPerModule($moduleDir); $fileNames = array(); foreach ($files as $k => $file) { $fileNames[] = $k; } $fileNamesLowerCase = array_map('strtolower', $fileNames); $isFound = array_search(strtolower($managerFileName), $fileNamesLowerCase); $managerFileName = ($isFound !== false) ? $fileNames[$isFound] : false; if (!($managerFileName)) { return false; } $filePath = $moduleDir . '/classes/' . $managerFileName; if (is_file($filePath)) { require_once $filePath; $aElems = explode('/', $filePath); $last = array_pop($aElems); $className = substr($last, 0, -4); $obj = new $className(); $vars = get_object_vars($obj); $actions = array_keys($vars['_aActionsMapping']); $ret = array(); foreach ($actions as $k => $action) { $ret[$action] = $action; } return $ret; } else { return false; } } function getAllClassesFromFolder($folder = '', $filter = '.*') { SGL::logMessage(null, PEAR_LOG_DEBUG); require_once 'File/Util.php'; $ret = SGL_Util::listDir($folder, FILE_LIST_FILES, $sort = FILE_SORT_NAME, create_function('$a', 'return preg_match("/^.*\.php$/", $a);')); $aClasses = array(); foreach ($ret as $k => $v) { if (preg_match("/^($filter)\.php$/", $v, $matches)) { $aClasses[$matches[1]] = $matches[1]; } } return $aClasses; } function listDir($path, $list = FILE_LIST_ALL, $sort = FILE_SORT_NONE, $cb = null) { $aRet = array(); if (is_array($aFiles = File_Util::listDir($path, $list, $sort, $cb))) { foreach ($aFiles as $oFile) { $aRet[$oFile->name] = $oFile->name; } } return $aRet; } function makeIniUnreadable($file) { $iniFle = file($file); $string = ';<?php die("Eat dust"); ?>' . "\n"; array_unshift($iniFle, $string); file_put_contents($file . '.php', implode('', $iniFle)); unlink($file); } function getLangsDescriptionMap($aSelected = array(), $langKeyType = null) { $availableLanguages = $GLOBALS['_SGL']['LANGUAGE']; uasort($availableLanguages, 'SGL_cmp'); $aLangs = array(); foreach ($availableLanguages as $id => $tmplang) { $langName = ucfirst(substr(strstr($tmplang[0], '|'), 1)); $keyId = ($langKeyType) ? SGL_Translation::transformLangID($id, $langKeyType) : $id; if (count($aSelected) && in_array($id, $aSelected)) { $aSelectedLangs[$keyId] = $langName . ' (' . $id . ')'; } else { $aLangs[$keyId] = $langName . ' (' . $id . ')'; } } $aLangs = (isset ($aSelectedLangs) && !empty($aSelectedLangs)) ? $aSelectedLangs : $aLangs; return $aLangs; } function loadParams($ini_file = '', $aSavedParams = array(), $aCurrentParams = array()) { $aReturn = array(); $details = ''; $aPreparedParams = array(); if (is_file($ini_file)) { $aParams = @parse_ini_file($ini_file, true); if (array_key_exists('details', $aParams)) { $details = (object)$aParams['details']; unset($aParams['details']); } foreach ($aParams as $key => $value) { if (is_array($value) && array_key_exists('value',$value) && array_key_exists('type',$value) && array_key_exists('label',$value)) { $value = array_key_exists($key, $aCurrentParams) ? $aCurrentParams[$key] : ''; if ($value) { $aParams[$key]['value'] = $value; } elseif (array_key_exists($key ,$aSavedParams)) { $aParams[$key]['value'] = $aSavedParams[$key]; } $aParams[$key]['name'] = 'aParams['.$key.']'; if ($aParams[$key]['type'] == 'wysiwyg') { $aReturn['wysiwyg'] = true; } $aPreparedParams[$key] = (object)$aParams[$key]; } } } $aReturn['details'] = $details; $aReturn['aParams'] = $aPreparedParams; return $aReturn; } function getTmpDir() { if (!empty($_ENV['TMP'])) { return realpath($_ENV['TMP']); } elseif (!empty($_ENV['TMPDIR'])) { return realpath($_ENV['TMPDIR']); } elseif (!empty($_ENV['TEMP'])) { return realpath($_ENV['TEMP']); } else { $temp_file = tempnam(md5(uniqid(rand(), true)), ''); if ($temp_file) { $temp_dir = realpath(dirname($temp_file)); unlink($temp_file); return $temp_dir; } else { return false; } } } } ?><?php
 class SGL_Config { var $aProps = array(); var $fileName; function SGL_Config($autoLoad = false) { $this->aProps = array(); if ($this->isEmpty() && $autoLoad) { $configFile = SGL_VAR_DIR . '/' . SGL_Task_SetupPaths::hostnameToFilename() . '.conf.php'; $conf = $this->load($configFile); $this->fileName = $configFile; $this->replace($conf); } } function &singleton($autoLoad = true) { static $instance; if (!isset($instance)) { $class = __CLASS__; $instance = new $class($autoLoad); } return $instance; } function exists($key) { if (is_array($key)) { $key1 = key($key); $key2 = $key[$key1]; return isset($this->aProps[$key1][$key2]); } else { return isset($this->aProps[$key]); } } function get($key) { if (is_array($key)) { $key1 = key($key); $key2 = $key[$key1]; if (isset( $this->aProps[$key1][$key2])) { $ret = $this->aProps[$key1][$key2]; } else { $ret = false; } } elseif (is_string($key)) { $c = &SGL_Config::singleton(); $aKeys = split('\.', trim($key)); if (isset($aKeys[0]) && isset($aKeys[1])) { $ret = $c->get(array($aKeys[0] => $aKeys[1])); } elseif (isset($this->aProps[$key])){ $ret = $this->aProps[$key]; } else { $key1 = isset($aKeys[0]) ? $aKeys[0] : 'no value' ; $key2 = isset($aKeys[1]) ? $aKeys[1] : 'no value' ; $ret = false; } } if (!isset($ret)) { SGL::logMessage("Config key '[$key1][$key2]' does not exist", PEAR_LOG_DEBUG); } return $ret; } function set($key, $value) { $ret = false; if (is_string($key) && is_scalar($value)) { $aKeys = split('\.', trim($key)); if (isset($aKeys[0]) && isset($aKeys[1])) { $c = &SGL_Config::singleton(); $ret = $c->set($aKeys[0], array($aKeys[1] => $value)); } else { $this->aProps[$key] = $value; $ret = true; } } elseif (is_string($key) && is_array($value)) { $key2 = key($value); $this->aProps[$key][$key2] = $value[$key2]; $ret = true; } return $ret; } function remove($key) { if (is_array($key)) { list($key1, $key2) = $key; unset($this->aProps[$key1][$key2]); } else { unset($this->aProps[$key]); } return true; } function replace($aConf) { $this->aProps = $aConf; } function getAll() { return $this->aProps; } function getFileName() { return $this->fileName; } function load($file, $force = false) { if (defined('SGL_INSTALLED')) { if (substr($file, -3, 3) != 'php') { if (!$force) { $cachedFileName = $this->getCachedFileName($file); if (!is_file($cachedFileName)) { $ok = $this->createCachedFile($cachedFileName); } $file = $cachedFileName; } } } $ph = &SGL_ParamHandler::singleton($file); $data = $ph->read(); if ($data !== false) { return $data; } else { if (defined('SGL_INITIALISED')) { return SGL::raiseError('Problem reading config file', SGL_ERROR_INVALIDFILEPERMS); } else { SGL::displayStaticPage('No global config file could be found, '. 'file searched for was ' .$file); } } } function getCachedFileName($path) { $path = str_replace('\\', '/', $path); if (basename($path) != 'conf.ini') { return $path; } preg_match("#(.*)\/(.*)\/(conf.ini)$#", $path, $aMatches); $moduleName = $aMatches[2]; $cachedFileName = SGL_VAR_DIR . '/config/' .$moduleName.'.ini'; return $cachedFileName; } function ensureCacheDirExists() { $varConfigDir = SGL_VAR_DIR . '/config'; if (!is_dir($varConfigDir)) { require_once 'System.php'; $ok = System::mkDir(array('-p', $varConfigDir)); @chmod($varConfigDir, 0777); } } function getModulesDir() { static $modDir; if (is_null($modDir)) { $c = &SGL_Config::singleton(); $customModDir = $c->get(array('path' => 'moduleDirOverride')); $modDir = !empty($customModDir) ? $customModDir : 'modules'; } return $modDir; } function createCachedFile($cachedModuleConfigFile) { $filename = basename($cachedModuleConfigFile); list($module, $ext) = split('\.', $filename); $masterModuleConfigFile = SGL_MOD_DIR . "/$module/conf.ini"; $this->ensureCacheDirExists(); $ok = copy($masterModuleConfigFile, $cachedModuleConfigFile); return $ok; } function save($file = null) { if (is_null($file)) { if (empty($this->fileName)) { return SGL::raiseError('No filename specified', SGL_ERROR_NOFILE); } $file = $this->fileName; } if ($file != $this->fileName) { $modDir = $this->getModulesDir(); if (stristr($file, $modDir) || stristr($file, 'modules')) { $this->ensureCacheDirExists(); $file = $this->getCachedFileName($file); } } $ph = &SGL_ParamHandler::singleton($file); return $ph->write($this->aProps); } function merge($aConf) { $this->aProps = SGL_Array::mergeReplace($this->aProps, $aConf); } function isEmpty() { return count($this->aProps) ? false : true; } function ensureModuleConfigLoaded($moduleName) { if (!defined('SGL_MODULE_CONFIG_LOADED') || $this->aProps['localConfig']['moduleName'] != $moduleName) { $path = SGL_MOD_DIR . '/' . $moduleName . '/conf.ini'; $modConfigPath = realpath($path); if ($modConfigPath) { $aModuleConfig = $this->load($modConfigPath); if (PEAR::isError($aModuleConfig)) { $ret = $aModuleConfig; } else { $this->merge($aModuleConfig); $this->set('localConfig', array('moduleName' => $moduleName)); $ret = $this->getAll(); } } else { $ret = SGL::raiseError("Config file could not be found at '$path'", SGL_ERROR_NOFILE); } } else { $ret = $this->getAll(); } return $ret; } function getCommandTarget($str) { if (empty($str)) { return false; } $aSplitResult = split('\^', $str); $aParams = array( 'moduleName' => null, 'managerName' => null, ); if (array_key_exists(0, $aSplitResult)) { $aParams['moduleName'] = $aSplitResult[0]; } if (array_key_exists(1, $aSplitResult)) { $aParams['managerName'] = $aSplitResult[1]; } if (array_key_exists(2, $aSplitResult)) { $aParams['action'] = $aSplitResult[2]; } return $aParams; } } ?><?php
 class SGL_ParamHandler { var $source; function SGL_ParamHandler($source) { $this->source = $source; } function &singleton($source) { static $instances; if (!isset($instances)) { $instances = array(); } $signature = md5($source); if (!isset($instances[$signature])) { $ext = substr($source, -3); switch ($ext) { case 'xml': $ret = new SGL_ParamHandler_Xml($source); break; case 'php': $ret = new SGL_ParamHandler_Array($source); break; case 'ini': $ret = new SGL_ParamHandler_Ini($source); break; } $instances[$signature] = $ret; } return $instances[$signature]; } function read() {} function write() {} } class SGL_ParamHandler_Ini extends SGL_ParamHandler { function read() { $ret = @parse_ini_file($this->source, true); return (count($ret)) ? $ret : false; } function write($data) { require_once 'Config.php'; $c = new Config(); $c->parseConfig($data, 'phparray'); $ok = $c->writeConfig($this->source, 'inifile'); return $ok; } } class SGL_ParamHandler_Array extends SGL_ParamHandler { function read() { if (is_file($this->source)) { $ok = require $this->source; if ($ok) { $ret = $conf; } else { $ret = $ok; } } else { $ret = false; } return $ret; } function write($data) { require_once 'Config.php'; $c = new Config(); $c->parseConfig($data, 'phparray'); $ok = $c->writeConfig($this->source, 'phparray'); return $ok; } } class SGL_ParamHandler_Xml extends SGL_ParamHandler { function read() { return simplexml_load_file($this->source); } function write($data) { require_once 'Config.php'; $c = new Config(); $c->parseConfig($data, 'phparray'); $ok = $c->writeConfig($this->source, 'xml'); return $ok; } } ?><?php
 class SGL_Registry { var $aProps = array(); function &singleton() { static $instance; if (!isset($instance)) { $class = __CLASS__; $instance = new $class(); } return $instance; } function &get($key) { if (array_key_exists($key, $this->aProps)) { $ret = $this->aProps[$key]; } else { $ret = null; } return $ret; } function set($key, &$value) { $this->aProps[$key] = &$value; } function exists($key) { return array_key_exists($key, $this->aProps); } function getRequest() { return $this->get('request'); } function setRequest($req) { $this->set('request', $req); } function getCurrentUrl() { return $this->get('currentUrl'); } function setCurrentUrl($url) { $this->set('currentUrl', $url); } function setFilters($aFilters) { $this->set('aFilters', $aFilters); } function getFilters() { return $this->get('aFilters'); } function getConfig() { $c = &SGL_Config::singleton(); return $c->getAll(); } function aggregate(& $dest) { SGL::logMessage(null, PEAR_LOG_DEBUG); $aObjAttrs = get_object_vars($this); if (is_array($aObjAttrs)) { foreach ($aObjAttrs as $objAttrName => $objAttrValue) { $dest->$objAttrName = $objAttrValue; } foreach ($dest->aProps as $k => $obj) { $dest->$k = $obj; } unset($dest->aProps); } } } ?><?php
 define('SGL_REQUEST_BROWSER', 1); define('SGL_REQUEST_CLI', 2); define('SGL_REQUEST_AJAX', 3); define('SGL_REQUEST_XMLRPC', 4); define('SGL_REQUEST_AMF', 5); class SGL_Request { var $aProps; function init($type = null) { if ($this->isEmpty()) { $type = (is_null($type)) ? $this->_getRequestType() : $type; $typeName = $this->constantToString($type); $file = SGL_CORE_DIR . '/Request/' . $typeName . '.php'; if (!is_file($file)) { return PEAR::raiseError('Request driver could not be located', SGL_ERROR_NOFILE); } require_once $file; $class = 'SGL_Request_' . $typeName; if (!class_exists($class)) { return PEAR::raiseError('Request driver class does not exist', SGL_ERROR_NOCLASS); } $obj = new $class(); error_log('##########   Req type: '.$class); $ok = $obj->init(); return PEAR::isError($ok) ? $ok : $obj; } } function constantToString($constant) { switch($constant) { case SGL_REQUEST_BROWSER: $ret = 'Browser'; if (SGL_Config::get('site.inputUrlHandlers') == 'Horde_Routes') { $ret = 'Browser2'; } break; case SGL_REQUEST_CLI: $ret = 'Cli'; break; case SGL_REQUEST_AJAX: $ret = 'Ajax'; if (SGL_Config::get('site.inputUrlHandlers') == 'Horde_Routes') { $ret = 'Ajax2'; } break; case SGL_REQUEST_AMF: $ret = 'Amf'; break; } return $ret; } function _getRequestType() { if (SGL::runningFromCLI()) { $ret = SGL_REQUEST_CLI; } elseif (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') { $ret = SGL_REQUEST_AJAX; } elseif (isset($_SERVER['CONTENT_TYPE']) && $_SERVER['CONTENT_TYPE'] == 'application/x-amf') { $ret = SGL_REQUEST_AMF; } else { $ret = SGL_REQUEST_BROWSER; } return $ret; } function &singleton($forceNew = false, $type = null) { static $instance; if (!isset($instance) || $forceNew) { $obj = new SGL_Request(); $instance = $obj->init($type); } return $instance; } function isEmpty() { return count($this->aProps) ? false : true; } function getType() { return $this->type; } function merge($aHash) { $firstKey = key($aHash); if (!array_key_exists($firstKey, $this->aProps)) { $this->aProps = array_merge_recursive($this->aProps, $aHash); } } function get($key, $allowTags = false) { if (isset($this->aProps[$key])) { $copy = $this->aProps[$key]; if (!$allowTags) { $clean = SGL_String::clean($copy); } else { $clean = SGL_String::removeJs($copy); } $this->set($key, $clean); return $this->aProps[$key]; } else { return null; } } function set($key, $value) { $this->aProps[$key] = $value; } function add($aParams) { $this->aProps = array_merge_recursive($this->aProps, $aParams); } function reset() { unset($this->aProps); $this->aProps = array(); } function getAll() { return $this->aProps; } function getModuleName() { if (isset($this->aProps['managerName'])) { $ret = $this->aProps['moduleName']; } else { $ret = SGL_Config::get('site.defaultModule'); } return $ret; } function getManagerName() { if (isset( $this->aProps['managerName'])) { $ret = $this->aProps['managerName']; } else { $ret = 'default'; } return $ret; } function getActionName() { if ( isset($this->aProps['action'])) { $ret = $this->aProps['action']; } else { $ret = 'default'; } return $ret; } function getUri() { $uri = ''; $sglSessionName = SGL_Config::get('cookie.name'); foreach ($this->aProps as $key => $value) { if (is_array($value)) { continue; } if (!empty($value) && $key != 'lang' && strpos($key, $sglSessionName) === false) { $uri .= ($key == 'moduleName' || $key == 'managerName') ? $value . '/' : $key . '/' . $value . '/'; } } $uri = preg_replace('/\/$/','',$uri); return $uri; } function debug() { $c = &SGL_Config::singleton(); $c->set('site', array('blocksEnabled' => 0)); print '<pre>'; print_r($this->aProps); } } ?><?php
 class SGL_Inflector { function isUrlSimplified($querystring, $sectionName) { if (!(empty($querystring))) { if (SGL_Inflector::urlContainsDuplicates($querystring)) { $ret = false; } else { $aUrlPieces = explode('/', $querystring); $moduleName = $aUrlPieces[0]; $aSections = explode('/', $sectionName); $ret = in_array($moduleName, $aSections) && (SGL_Inflector::urlContainsDuplicates($sectionName)); } } else { $ret = false; } return $ret; } function urlContainsDuplicates($url) { if (!empty($url)) { $aPieces = explode('/', $url); $initial = count($aPieces); $unique = count(array_unique($aPieces)); $ret = $initial != $unique; } else { $ret = false; } return $ret; } function isMgrNameOmitted($aParsedUri) { $fullMgrName = SGL_Inflector::getManagerNameFromSimplifiedName( $aParsedUri['managerName']); $corrected = SGL_Inflector::caseFix($fullMgrName, true); $path = SGL_MOD_DIR . '/'. $aParsedUri['moduleName'] . '/classes/' . $corrected . '.php'; if (!is_file($path)) { $mgrName = SGL_Inflector::getManagerNameFromSimplifiedName($aParsedUri['moduleName']); $corrected = SGL_Inflector::caseFix($mgrName, true); $pathToMgr = SGL_MOD_DIR . '/'. $aParsedUri['moduleName'] . '/classes/' . $corrected . '.php'; $ret = is_file($pathToMgr); } else { $ret = false; } return $ret; } function getManagerNameFromSimplifiedName($name) { if (strtolower(substr($name, -3)) != 'mgr') { $name .= 'Mgr'; } return SGL_Inflector::caseFix(ucfirst($name), $force = true); } function getSimplifiedNameFromManagerName($name) { if (substr($name, -4) == '.php') { $name = substr($name, 0, -4); } if (strtolower(substr($name, -3)) == 'mgr') { $name = substr($name, 0, -3); } return strtolower($name); } function camelise($s) { $ret = ''; $i = 0; $s = preg_replace('!\s+!', ' ', $s); $s = trim($s); $aString = explode(' ', $s); foreach ($aString as $value) { if ($i == 0) { $ret .= strtolower($value); } else { $ret .= ucfirst(strtolower($value)); } $i++; } return $ret; } function getTitleFromCamelCase($camelCaseWord) { if (!SGL_Inflector::isCamelCase($camelCaseWord)) { return $camelCaseWord; } $ret = ''; for ($x = 0; $x < strlen($camelCaseWord); $x ++) { if (preg_match("/[A-Z]/", $camelCaseWord{$x})) { $ret .= ' '; } $ret .= $camelCaseWord{$x}; } return ucfirst($ret); } function isCamelCase($str) { if (preg_match("/[^a-z].*/i", $str)) { return false; } for ($x = 1; $x < strlen($str)-1; $x ++) { if (preg_match("/[A-Z]/", $str{$x})) { return true; } } } function isConstant($str) { if (empty($str)) { return false; } if (preg_match('/sessid/i', $str)) { return false; } $pattern = '@^[A-Z_\']*$@'; if (!preg_match($pattern, $str)) { return false; } return true; } function humanise($lowerCaseAndUnderscoredWord) { $replace = ucwords(str_replace("_", " ", $lowerCaseAndUnderscoredWord)); return $replace; } function caseFix($str, $force = false) { if (!$force && (($phpVersion{0} = PHP_VERSION) == 5)) { return $str; } $c = &SGL_Config::singleton(); $conf = $c->getAll(); $aConfValues = array_keys($conf); $aConfValuesLowerCase = array_map('strtolower', $aConfValues); $isFound = array_search(strtolower($str), $aConfValuesLowerCase); if (!$isFound) { if ($str == 'ArticleviewMgr') { $str = 'ArticleViewMgr'; } } return ($isFound !== false) ? $aConfValues[$isFound] : $str; } } ?><?php
 class SGL_Date { function getTime($gmt = false) { $time = ($gmt) ? gmstrftime("%Y-%m-%d %H:%M:%S", time()) : strftime("%Y-%m-%d %H:%M:%S", time()); return $time; } function arrayToString($aDate) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (is_array($aDate)) { $month = $aDate['month']; $day = $aDate['day']; $year = $aDate['year']; $hour = (array_key_exists('hour',$aDate))? $aDate['hour'] : '00'; $minute = (array_key_exists('minute',$aDate))? $aDate['minute'] : '00'; $second = (array_key_exists('second',$aDate))? $aDate['second'] : '00'; if (empty($month) && empty($year) && empty($day)) { return null; } else { return $year . '-' . $month . '-' . $day .' ' . $hour . ':' . $minute . ':' . $second; } } } function stringToArray($sDate) { SGL::logMessage(null, PEAR_LOG_DEBUG); if (is_scalar($sDate)) { require_once 'Date.php'; $date = & new Date($sDate); $aDate = array('day' => $date->getDay(), 'month' => $date->getMonth(), 'year' => $date->getYear(), 'hour' => $date->getHour(), 'minute' => $date->getMinute(), 'second' => $date->getSecond()); return $aDate; } } function formatPretty($date) { if (is_string($date)) { require_once 'Date.php'; $date = & new Date($date); if ($_SESSION['aPrefs']['dateFormat'] == 'FR') { $output = $date->format('%d %B %Y, %H:%M'); } elseif ($_SESSION['aPrefs']['dateFormat'] == 'BR') { $output = $date->format('%d de %B de %Y %H:%M'); } elseif ($_SESSION['aPrefs']['dateFormat'] == 'DE') { $output = $date->format('%d. %B %Y %H:%M'); } else { $output = $date->format('%B %d, %Y %H:%M'); } return $output; } else { SGL::raiseError('no input date passed to SGL_Date::formatPretty incorrect type', SGL_ERROR_INVALIDARGS); } } function format($date) { if (is_string($date)) { include_once 'Date.php'; $date = & new Date($date); if ($_SESSION['aPrefs']['dateFormat'] == 'UK') { $output = $date->format('%d.%m.%Y'); } elseif ($_SESSION['aPrefs']['dateFormat'] == 'BR' || $_SESSION['aPrefs']['dateFormat'] == 'FR') { $output = $date->format('%d/%m/%Y'); } elseif ($_SESSION['aPrefs']['dateFormat'] == 'US') { $output = $date->format('%m.%d.%Y'); } elseif ($_SESSION['aPrefs']['dateFormat'] == 'DE') { $output = $date->format('%d.%m.%Y'); } else { $output = $date->format('%Y-%m-%d'); } return $output; } else { SGL::raiseError('no input date passed to SGL_Date::format incorrect type', SGL_ERROR_INVALIDARGS); } } function getDateFormat() { if ($_SESSION['aPrefs']['dateFormat'] == 'UK') { $dateFormat = '%d %B %Y, %H:%M'; } elseif ($_SESSION['aPrefs']['dateFormat'] == 'BR' || $_SESSION['aPrefs']['dateFormat'] == 'FR') { $dateFormat = '%d %B %Y, %H:%M'; } elseif ($_SESSION['aPrefs']['dateFormat'] == 'US') { $dateFormat = '%B %d, %Y %H:%M'; } elseif ($_SESSION['aPrefs']['dateFormat'] == 'DE') { $dateFormat = '%d.%B.%Y %H:%M'; } else { $dateFormat = '%Y-%B-%d'; } return $dateFormat; } function getDayFormOptions($selected = '') { SGL::logMessage(null, PEAR_LOG_DEBUG); $day_options = ''; for ($i = 1; $i <= 31; $i++) { $day_options .= "\n<option value=\"" . sprintf('%02d', $i) . '" '; if ($i == $selected) { $day_options .= 'selected="selected"'; } $day_options .= '>' . sprintf('%02d', $i) . '</option>'; } return $day_options; } function getMonthFormOptions($selected = '') { SGL::logMessage(null, PEAR_LOG_DEBUG); $aMonths = SGL_String::translate('aMonths'); $monthOptions = ''; if (empty($selected) && $selected != null) { $selected = date('m', time()); } if (count($aMonths)) { foreach ($aMonths as $k => $v) { $monthOptions .= "\n<option value=\"$k\" "; if ($k == $selected) { $monthOptions .= 'selected="selected"'; } $monthOptions .= '>' . $v . '</option>'; } } return $monthOptions; } function getYearFormOptions($selected = '', $asc = true, $totalYears = 5) { SGL::logMessage(null, PEAR_LOG_DEBUG); $yearOptions = ''; $curYear = date('Y', time()); $startYear = $curYear; if ($asc) { for ($i = $startYear; $i <= $startYear + $totalYears; $i++) { $yearOptions .= "\n<option value=\"" . $i . '" '; if ($i == $selected) { $yearOptions .= 'selected="selected"'; } $yearOptions .= '>' . $i . '</option>'; } } else { for ($i = $startYear; $i >= $startYear - ($totalYears - 1); $i--) { $yearOptions .= "\n<option value=\"" . $i . '" '; if ($i == $selected) { $yearOptions .= 'selected="selected"'; } $yearOptions .= '>' . $i . '</option>'; } } return $yearOptions; } function getHourFormOptions($selected = '') { SGL::logMessage(null, PEAR_LOG_DEBUG); $hour_options = ''; for ($i = 0; $i <= 23; $i++) { $hval = sprintf("%02d", $i); $hour_options .= "\n<option value=\"" . $hval . '" '; if ($selected == $i && $selected !='' ) { $hour_options .= 'selected="selected"'; } $hour_options .= '>' . $hval . '</option>'; } return $hour_options; } function getMinSecOptions($selected = '') { SGL::logMessage(null, PEAR_LOG_DEBUG); $minute_options = ''; for ($i = 0; $i <= 59; $i++) { $minute_options .= "\n<option value=\"" . sprintf("%02d", $i) . '" '; if ($selected == $i && $selected !="" ) { $minute_options .= 'selected="selected"'; } $minute_options .= '>' . sprintf("%02d", $i) . '</option>'; } return $minute_options; } function showDateSelector($aDate, $elementName, $bShowTime = true, $asc = true, $years = 5) { SGL::logMessage(null, PEAR_LOG_DEBUG); $html = ''; $month_html = "\n<select name='" . $elementName . "[month]' id='".$elementName."_month' >" . SGL_Date::getMonthFormOptions($aDate['month']) . '</select> / '; $day_html = "\n<select name='" . $elementName . "[day]' id='".$elementName."_day'>" . SGL_Date::getDayFormOptions($aDate['day']) . '</select> / '; if ($_SESSION['aPrefs']['dateFormat'] == 'US') { $html .= $month_html . $day_html; } else { $html .= $day_html . $month_html; } $html .= "\n<select name='" . $elementName . "[year]' id='".$elementName."_year'>" . SGL_Date::getYearFormOptions($aDate['year'], $asc, $years) . '</select>'; if ($bShowTime) { $html .= '&nbsp;&nbsp; '; $html .= SGL_String::translate('at time'); $html .= ' &nbsp;&nbsp;'; $html .= "\n<select name='" . $elementName . "[hour]'  id='".$elementName."_hour'>" . SGL_Date::getHourFormOptions($aDate['hour']) . '</select> : '; $html .= "\n<select name='" . $elementName . "[minute]' id='".$elementName."_minute'>" . SGL_Date::getMinSecOptions($aDate['minute']) . '</select> : '; $html .= "\n<select name='" . $elementName . "[second]' id='".$elementName."_second'>" . SGL_Date::getMinSecOptions($aDate['second']) . '</select>'; } return $html; } } ?>
<?php
 class SGL_Array { function removeBlanks($elem) { if (is_array($elem)) { $clean = array_filter($elem); } else { SGL::raiseError('array argument expected, got ' . gettype($elem), SGL_ERROR_INVALIDARGS); } return $clean; } function implodeWithKeys($glue, $hash, $valwrap='') { if (is_array($hash) && count($hash)) { foreach ($hash as $key => $value) { $aResult[] = $key.$glue.$valwrap.$value.$valwrap; } $ret = implode($glue, $aResult); } else { $ret = ''; } return $ret; } function mergeReplace($array, $newValues) { foreach ($newValues as $key => $value) { if (is_array($value)) { if (!isset($array[$key])) { $array[$key] = array(); } $array[$key] = SGL_Array::mergeReplace($array[$key], $value); } else { if (isset($array[$key]) && is_array($array[$key])) { $array[$key][0] = $value; } else { if (isset($array) && !is_array($array)) { $temp = $array; $array = array(); $array[0] = $temp; } $array[$key] = $value; } } } return $array; } } ?><?php
 class SGL_Error { function count() { return count($GLOBALS['_SGL']['ERRORS']); } function push($oError) { return array_push($GLOBALS['_SGL']['ERRORS'], $oError); } function pop() { return array_pop($GLOBALS['_SGL']['ERRORS']); } function shift() { return array_shift($GLOBALS['_SGL']['ERRORS']); } function getLast() { return end($GLOBALS['_SGL']['ERRORS']); } function reset() { unset($GLOBALS['_SGL']['ERRORS']); $GLOBALS['_SGL']['ERRORS'] = array(); return true; } function toString($oError) { $message = $oError->getMessage(); $debugInfo = $oError->getDebugInfo(); $level = $oError->getCode(); $errorType = SGL_Error::constantToString($level); $output = <<<EOF
  <strong>MESSAGE</strong>: $message<br />
  <strong>TYPE:</strong> $errorType<br />
  <strong>DEBUG INFO:</strong> $debugInfo<br />
  <strong>CODE:</strong> $level<br />
EOF;
return $output; } function constantToString($errorCode) { $aErrorCodes = array( SGL_ERROR_INVALIDARGS => 'invalid arguments', SGL_ERROR_INVALIDCONFIG => 'invalid config', SGL_ERROR_NODATA => 'no data', SGL_ERROR_NOCLASS => 'no class', SGL_ERROR_NOMETHOD => 'no method', SGL_ERROR_NOAFFECTEDROWS => 'no affected rows', SGL_ERROR_NOTSUPPORTED => 'not supported', SGL_ERROR_INVALIDCALL => 'invalid call', SGL_ERROR_INVALIDAUTH => 'invalid auth', SGL_ERROR_EMAILFAILURE => 'email failure', SGL_ERROR_DBFAILURE => 'db failure', SGL_ERROR_DBTRANSACTIONFAILURE => 'db transaction failure', SGL_ERROR_BANNEDUSER => 'banned user', SGL_ERROR_NOFILE => 'no file', SGL_ERROR_INVALIDFILEPERMS => 'invalid file perms', SGL_ERROR_INVALIDSESSION => 'invalid session', SGL_ERROR_INVALIDPOST => 'invalid post', SGL_ERROR_INVALIDTRANSLATION => 'invalid translation', SGL_ERROR_FILEUNWRITABLE => 'file unwritable', SGL_ERROR_INVALIDREQUEST => 'invalid request', SGL_ERROR_INVALIDTYPE => 'invalid type', SGL_ERROR_RECURSION => 'recursion', SGL_ERROR_RESOURCENOTFOUND => 'page not found', ); if (in_array($errorCode, array_keys($aErrorCodes))) { return strtoupper($aErrorCodes[$errorCode]); } else { return 'PEAR'; } } } ?><?php
 require_once 'Cache/Lite.php'; class SGL_Cache { function &singleton($type = 'default', $aOptions = array(), $forceNew = false) { static $aInstances; if (is_bool($type)) { if ($type) { $forceNew = true; } $type = 'default'; } $key = $type . '-' . md5(serialize($aOptions)); if (!isset($aInstances[$key]) || $forceNew) { $isEnabled = $forceNew ? true : SGL_Config::get('cache.enabled'); $aDefaultOptions = array( 'cacheDir' => SGL_TMP_DIR . '/', 'lifeTime' => SGL_Config::get('cache.lifetime'), 'caching' => $isEnabled ); if (SGL_Config::get('cache.cleaningFactor')) { $aDefaultOptions['automaticCleaningFactor'] = SGL_Config::get('cache.cleaningFactor'); } if (SGL_Config::get('cache.readControl')) { $aDefaultOptions['readControl'] = SGL_Config::get('cache.readControl'); } if (SGL_Config::get('cache.writeControl')) { $aDefaultOptions['writeControl'] = SGL_Config::get('cache.writeControl'); } $aOptions = array_merge($aDefaultOptions, $aOptions); switch (strtolower($type)) { case 'output': require_once 'Cache/Lite/Output.php'; $className = 'Cache_Lite_Output'; break; case 'function': require_once 'Cache/Lite/Function.php'; $className = 'Cache_Lite_Function'; break; default: $className = 'SGL_Cache_Lite'; } $aInstances[$key] = & new $className($aOptions); } return $aInstances[$key]; } function clear($group = false, $mode = 'ingroup', $options = array()) { $cache = &SGL_Cache::singleton(); return $cache->clean($group, $mode, $options); } } class SGL_Cache_Lite extends Cache_Lite { function clean($group = false, $mode = 'ingroup', $options = array()) { return $this->_cleanDir($this->_cacheDir, $group, $mode, $options); } function _cleanDir($dir, $group = false, $mode = 'ingroup', $options = array()) { if ($this->_fileNameProtection) { $motif = ($group) ? 'cache_'.md5($group).'_' : 'cache_'; } else { $motif = ($group) ? 'cache_'.$group.'_' : 'cache_'; } if ($this->_memoryCaching) { while (list($key, ) = each($this->_memoryCachingArray)) { if (strpos($key, $motif, 0)) { unset($this->_memoryCachingArray[$key]); $this->_memoryCachingCounter = $this->_memoryCachingCounter - 1; } } if ($this->_onlyMemoryCaching) { return true; } } if (!($dh = opendir($dir))) { return $this->raiseError('Cache_Lite : Unable to open cache directory !', -4); } $objectCallback = false; if (!is_string($mode) && is_callable($mode)) { $objectCallback = true; } $result = true; while ($file = readdir($dh)) { if (($file != '.') && ($file != '..')) { if (substr($file, 0, 6)=='cache_') { $file2 = $dir . $file; if (is_file($file2)) { $match = ($objectCallback) ? 'callback_' : substr($mode, 0, 9); switch ($match) { case 'old': if (!is_null($this->_lifeTime)) { if ((mktime() - @filemtime($file2)) > $this->_lifeTime) { $result = ($result and ($this->_unlink($file2))); } } break; case 'notingrou': if (!strpos($file2, $motif, 0)) { $result = ($result and ($this->_unlink($file2))); } break; case 'callback_': if ($objectCallback) { if (call_user_func_array($mode, $options)) { $result = ($result and ($this->_unlink($file2))); } } else { $func = substr($mode, 9, strlen($mode) - 9); if ($func($file2, $group)) { $result = ($result and ($this->_unlink($file2))); } } break; case 'ingroup': default: if (strpos($file2, $motif, 0)) { $result = ($result and ($this->_unlink($file2))); } break; } } if ((is_dir($file2)) and ($this->_hashedDirectoryLevel>0)) { $result = ($result and ($this->_cleanDir($file2 . '/', $group, $mode))); } } } } return $result; } } ?><?php
 define('SGL_DSN_ARRAY', 0); define('SGL_DSN_STRING', 1); class SGL_DB { function &singleton($dsn = null) { $msg = 'Cannot connect to DB, check your credentials'; $dsn = (is_null($dsn)) ? SGL_DB::getDsn(SGL_DSN_STRING) : $dsn; if (empty($dsn['phptype'])) { return PEAR::raiseError($msg, SGL_ERROR_DBFAILURE); } $c = &SGL_Config::singleton(); $conf = $c->getAll(); static $aInstances; if (!isset($aInstances)) { $aInstances = array(); } $signature = md5($dsn); if (!isset($aInstances[$signature])) { $conn = DB::connect($dsn); if (PEAR::isError($conn)) { if ($conn->getCode() == DB_ERROR_CONNECT_FAILED) { $oLastStackError = SGL_Error::pop(); $oLastStackError->userinfo = ''; SGL_Error::push($oLastStackError); } if (is_file(SGL_VAR_DIR . '/INSTALL_COMPLETE.php') && defined('SGL_INSTALLED')) { $msg .= 'If you remove the file seagull/var/INSTALL_COMPLETE.php you will be'. ' able to run the setup again.'; } $err = SGL::raiseError($msg, SGL_ERROR_DBFAILURE); return $err; } if (!empty($conf['db']['postConnect'])) { $conn->query($conf['db']['postConnect']); } $conn->setFetchMode(DB_FETCHMODE_OBJECT); $aInstances[$signature] = $conn; } return $aInstances[$signature]; } function getDsn($type = SGL_DSN_ARRAY, $excludeDbName = false) { $c = &SGL_Config::singleton(); $conf = $c->getAll(); if (!count($conf)) { return false; } $locator = &SGL_ServiceLocator::singleton(); $dbh = $locator->get('DB'); if ($dbh && count($dbh->dsn)) { $locatorDsn = $dbh->dsn; $conf['db']['user'] = $locatorDsn['username']; $conf['db']['pass'] = $locatorDsn['password']; $conf['db']['protocol'] = $locatorDsn['protocol']; $conf['db']['socket'] = $locatorDsn['socket']; $conf['db']['host'] = $locatorDsn['hostspec']; $conf['db']['port'] = $locatorDsn['port']; $conf['db']['name'] = $locatorDsn['database']; } if ($type == SGL_DSN_ARRAY) { $dsn = SGL_DB::_getDsnAsArray($conf, $excludeDbName); } else { $dsn = SGL_DB::_getDsnAsString($conf, $excludeDbName); } return $dsn; } function _getDsnAsArray($conf, $excludeDbName = false) { $dsn = array( 'phptype' => $conf['db']['type'], 'username' => $conf['db']['user'], 'password' => $conf['db']['pass'], 'protocol' => $conf['db']['protocol'], 'socket' => $conf['db']['socket'], 'hostspec' => $conf['db']['host'], 'port' => $conf['db']['port'] ); if (!$excludeDbName) { $dsn['database'] = $conf['db']['name']; } return $dsn; } function _getDsnAsString($conf, $excludeDbName = false) { $socket = (isset($conf['db']['protocol']) && $conf['db']['protocol'] == 'unix' && !empty($conf['db']['socket'])) ? '(' . $conf['db']['socket'] . ')' : ''; $protocol = isset($conf['db']['protocol']) ? $conf['db']['protocol'] . $socket : ''; $host = !empty($conf['db']['host']) ? $conf['db']['host'] : ''; $host = empty($conf['db']['socket']) ? '+' . $host : ''; $port = (!empty($conf['db']['port']) && isset($conf['db']['protocol']) && ($conf['db']['protocol'] == 'tcp')) ? ':' . $conf['db']['port'] : ''; $type = !empty($conf['db']['type']) ? $conf['db']['type'] : ''; $user = !empty($conf['db']['user']) ? $conf['db']['user'] : ''; $passwd = !empty($conf['db']['pass']) ? $conf['db']['pass'] : ''; $dsn = $type . '://' . $user . ':' . $passwd . '@' . $protocol . $host . $port; if (!$excludeDbName && isset($conf['db']['name'])) { $dsn .= '/' . $conf['db']['name']; } return $dsn; } function setConnection($dsn = null) { $locator = &SGL_ServiceLocator::singleton(); $singleton = $locator->get('DB'); if (!$singleton) { $singleton = & SGL_DB::singleton(); $locator->register('DB', $singleton); } $dsn = (is_null($dsn)) ? SGL_DB::getDsn(SGL_DSN_STRING) : $dsn; $dsnMd5 = md5($dsn); unset($GLOBALS['_DB_DATAOBJECT']['CONNECTIONS'][$dsnMd5]); $GLOBALS['_DB_DATAOBJECT']['CONNECTIONS'][$dsnMd5] = &$singleton; } function rewriteCountQuery($sql) { if (preg_match('/^\s*SELECT\s+\bDISTINCT\b/is', $sql) || preg_match('/\s+GROUP\s+BY\s+/is', $sql)) { return false; } $queryCount = preg_replace('/(?:.*)\bFROM\b\s+/Uims', 'SELECT COUNT(*) FROM ', $sql, 1); list($queryCount, ) = preg_split('/\s+ORDER\s+BY\s+/is', $queryCount); list($queryCount, ) = preg_split('/\bLIMIT\b/is', $queryCount); return trim($queryCount); } function getPagedData(&$db, $query, $pager_options = array(), $disabled = false, $fetchMode = DB_FETCHMODE_ASSOC, $dbparams = array()) { if (!array_key_exists('totalItems', $pager_options) || is_null($pager_options['totalItems'])) { if ($countQuery = SGL_DB::rewriteCountQuery($query)) { $totalItems = $db->getOne($countQuery, $dbparams); if (PEAR::isError($totalItems)) { return $totalItems; } } else { $res =& $db->query($query, $dbparams); if (PEAR::isError($res)) { return $res; } $totalItems = (int)$res->numRows(); $res->free(); } $pager_options['totalItems'] = $totalItems; } require_once 'Pager/Pager.php'; $req =& SGL_Request::singleton(); $pager_options['currentPage'] = (array_key_exists('currentPage', $pager_options)) ? $pager_options['currentPage'] : $req->get('pageID'); $pager_options['append'] = isset($pager_options['append']) ? $pager_options['append'] : false; $pager_options['fileName'] = isset($pager_options['fileName']) ? $pager_options['fileName'] : '/pageID/%d/'; $pager_options['altPrev'] = SGL_String::translate('altPrev'); $pager_options['altNext'] = SGL_String::translate('altNext'); $pager_options['altPage'] = SGL_String::translate('altPage'); $pager_options['prevImg'] = SGL_String::translate('prevImg'); $pager_options['nextImg'] = SGL_String::translate('nextImg'); $pager = Pager::factory($pager_options); $page = array(); $page['totalItems'] = $pager_options['totalItems']; $page['links'] = str_replace("/pageID/".$pager->getCurrentPageID()."/", "/", $pager->links); $page['page_numbers'] = array( 'current' => $pager->getCurrentPageID(), 'total' => $pager->numPages() ); list($page['from'], $page['to']) = $pager->getOffsetByPageId(); $res = ($disabled) ? $db->limitQuery($query, 0, $page['totalItems'], $dbparams) : $db->limitQuery($query, $page['from']-1, $pager_options['perPage'], $dbparams); if (PEAR::isError($res)) { return $res; } $page['data'] = array(); while ($res->fetchInto($row, $fetchMode)) { $page['data'][] = $row; } if ($disabled) { $page['links'] = ''; $page['page_numbers'] = array( 'current' => 1, 'total' => 1 ); } return $page; } } class SGL_ServiceLocator { var $aServices = array(); function &singleton() { static $instance; if (!$instance) { $class = __CLASS__; $instance = new $class(); } return $instance; } function register($serviceName, &$oService) { $this->aServices[$serviceName] = &$oService; return true; } function remove($serviceName) { unset($this->aServices[$serviceName]); } function &get($serviceName) { if (isset($this->aServices[$serviceName])) { $ret = $this->aServices[$serviceName]; } else { $ret = false; } return $ret; } function &staticGet($serviceName) { $oServiceLocator = &SGL_ServiceLocator::singleton(); return $oServiceLocator->get($serviceName); } } ?>
<?php
 class SGL_BlockLoader { var $_aData = array(); var $aBlocks = array(); var $_rid = 0; var $_currentSectionId = 0; function SGL_BlockLoader($sectionId) { $this->_rid = (int)SGL_Session::get('rid'); if (isset($sectionId)) { $this->_currentSectionId = $sectionId; } } function render(&$output) { $this->output = &$output; $cache = & SGL_Cache::singleton(); $currLang = (isset($output->currLang)) ? $output->currLang : ''; $charset = (isset($output->charset)) ? $output->charset : ''; $cacheId = $this->_currentSectionId . $this->_rid . $currLang . $charset; if ($data = $cache->get($cacheId, 'blocks')) { $this->aBlocks = unserialize($data); $this->_loadBlocks(false); SGL::logMessage('blocks from cache', PEAR_LOG_DEBUG); } else { $this->_loadBlocks(); $data = serialize($this->aBlocks); $cache->save($data, $cacheId, 'blocks'); SGL::logMessage('blocks from db', PEAR_LOG_DEBUG); } return $this->aBlocks; } function _loadBlocks($getAll = true) { $dbh = & SGL_DB::singleton(); $addWhere = $getAll ? '' : "AND b.is_cached = 0 "; $b = SGL_Config::get('table.block'); $ba = SGL_Config::get('table.block_assignment'); $br = SGL_Config::get('table.block_role'); $query = "
            SELECT
                b.block_id, b.name, b.title, b.title_class,
                b.body_class, b.position, b.params, b.is_cached
            FROM    $b b, $ba ba, $br br
            WHERE   b.is_enabled = 1 " . $addWhere . "AND     (br.block_id = b.block_id AND
                      (br.role_id = '" . SGL_Session::getRoleId() . "' OR br.role_id = '" . SGL_ANY_ROLE . "')
                    )
            AND     b.block_id = ba.block_id
            AND     ( ba.section_id = ".SGL_ANY_SECTION." OR ba.section_id = " . $this->_currentSectionId . ' )
            ORDER BY b.blk_order
        '; $aResult = $dbh->getAll($query); if (!PEAR::isError($aResult)) { $this->_aData = $aResult; $this->_buildBlocks(); } else { SGL::raiseError('section ID not found', SGL_ERROR_NODATA); } } function _buildBlocks() { if (count($this->_aData) > 0 ) { foreach ($this->_aData as $index => $oBlock) { $blockClass = $oBlock->name; preg_match('/^(.*)_.*_(.*)$/', $blockClass, $aMatches); @$blockPath = strtolower($aMatches[1]) . '/blocks/' . $aMatches[2]; if (SGL::moduleIsEnabled('cms') && $blockPath == 'navigation/blocks/Navigation') { $blockPath = 'cms/blocks/Navigation'; $blockClass = 'Cms_Block_Navigation'; } if (file_exists( SGL_MOD_DIR . '/' . $blockPath . '.php')) { require_once SGL_MOD_DIR . '/' . $blockPath . '.php'; } else { unset($this->_aData[$index]); SGL::raiseError('cannot load ' . $blockClass . '; ' . $blockPath . '.php does not exist', SGL_ERROR_NOFILE); } if (!class_exists($blockClass)) { unset($this->_aData[$index]); SGL::raiseError($blockClass . ' is not a valid block classname', SGL_ERROR_NOCLASS); } else { if (is_scalar($aParams = @unserialize($oBlock->params))) { $aParams = array(); } @$obj = & new $blockClass(); if ($data = $obj->init($this->output, $oBlock->block_id, $aParams)) { $this->_aData[$index]->content = $data; } else { unset($this->_aData[$index]); } } } $this->_sort(); } } function _sort() { if (count($this->_aData) > 0) { foreach ($this->_aData as $oBlock) { $this->aBlocks[$oBlock->position][$oBlock->block_id] = $oBlock; } } unset($this->_aData); } } ?>
<?php
 class SGL_Translation { function &singleton($type = 'translation') { static $instance; if (isset($instance[$type])) { return $instance[$type]; } $c = &SGL_Config::singleton(); $conf = $c->getAll(); $dbh = SGL_DB::singleton(); $params = array( 'langs_avail_table' => $conf['db']['prefix'] . 'langs', 'lang_id_col' => 'lang_id', 'lang_name_col' => 'name', 'lang_meta_col' => 'meta', 'lang_errmsg_col' => 'error_text', 'lang_encoding_col' => 'encoding', 'string_id_col' => 'translation_id', 'string_page_id_col' => 'page_id', 'string_text_col' => '%s' ); $driver = 'DB'; if ($conf['translation']['container'] == 'db') { $prefix = $conf['db']['prefix'] . $conf['translation']['tablePrefix'] . '_'; $aLangs = explode(',', $conf['translation']['installedLanguages']); foreach ($aLangs as $lang) { $params['strings_tables'][$lang] = $prefix . $lang; } } else { SGL::raiseError('translation table not specified check global config ', SGL_ERROR_INVALIDCONFIG, PEAR_ERROR_DIE); } switch (strtolower($type)) { case 'admin': require_once 'Translation2/Admin.php'; $instance[$type] = &Translation2_Admin::factory($driver, $dbh, $params); break; case 'translation': default: require_once 'Translation2.php'; $instance[$type] = &Translation2::factory($driver, $dbh, $params); } return $instance[$type]; } function clearCache() { $c = &SGL_Config::singleton(); $conf = $c->getAll(); if ('db' == $conf['translation']['container']) { $trans = SGL_Translation::singleton('admin'); $trans->options['cacheOptions']['cacheDir'] = SGL_TMP_DIR .'/'; $trans->options['cacheOptions']['defaultGroup'] = 'translation'; return $trans->cleanCache(); } else { return SGL_Translation::clearGuiTranslationsCache(); } } function clearGuiTranslationsCache() { $c = &SGL_Config::singleton(); $aLangs = $aLangs = explode(',', $this->conf['translation']['installedLanguages']); if (count($aLangs) > 0) { $cache = & SGL_Cache::singleton(); $cache->setOption('cacheDir', SGL_TMP_DIR .'/'); $success = true; foreach ($aLangs as $group) { $group = SGL_Translation::transformLangID($group, SGL_LANG_ID_SGL); $result = SGL_Cache::clear('translation_'. $group); $success = $success && $result; } return $success; } } function getGuiTranslationsFromFile($module, $lang) { $cache = & SGL_Cache::singleton(); $lang = SGL_Translation::transformLangID($lang, SGL_LANG_ID_SGL); $ret = array(); if ($serialized = $cache->get($module, 'translation_'. $lang)) { $words = unserialize($serialized); SGL::logMessage('translations from cache', PEAR_LOG_DEBUG); $ret = $words; } else { $aLanguages = $GLOBALS['_SGL']['LANGUAGE']; $language = @$aLanguages[$lang][1]; $globalLangFile = $language .'.php'; $path = SGL_MOD_DIR . '/' . $module . '/lang/'; if (!is_readable($path . $globalLangFile)) { $fallbackLang = SGL_Config::get('translation.fallbackLang'); $fallbackLang = SGL_Translation::transformLangID($fallbackLang, SGL_LANG_ID_SGL); $language = @$aLanguages[$fallbackLang][1]; $globalLangFile = $language .'.php'; } if (is_readable($path . $globalLangFile)) { include $path . $globalLangFile; if ($module == 'default') { $words = &$defaultWords; } if (!empty($words)) { $serialized = serialize($words); $cache->save($serialized, $module, 'translation_'. $lang); SGL::logMessage('translations from file', PEAR_LOG_DEBUG); } $ret = $words; } elseif ($module == 'default') { SGL::raiseError('could not locate the global language file', SGL_ERROR_NOFILE); } } return SGL_Translation::removeMetaData($ret); } function updateGuiTranslations($module, $langID, $aTrans) { switch (strtolower($this->conf['translation']['container'])) { case 'db': require_once SGL_CORE_DIR . '/Translation.php'; $trans = &SGL_Translation::singleton('admin'); $langID = SGL_Translation::transformLangID($langID, SGL_LANG_ID_TRANS2); foreach ($aTrans as $key => $value) { $string = array($langID => $value); $result = $trans->add(stripslashes($key), $module, $string); if (is_a($result, 'PEAR_Error')) { return $result; } } return true; case 'file': default: $aTrans = SGL_Translation::updateMetaData($aTrans); $c = new Config(); $aTransStrip = SGL_Translation::escapeSingleQuoteInArrayKeys($aTrans); $root = & $c->parseConfig($aTransStrip, 'phparray'); $langID = SGL_Translation::transformLangID($langID, SGL_LANG_ID_SGL); $filename = SGL_Translation::getFileName($module, $langID); $arrayName = ($module == 'default') ? 'defaultWords' : 'words'; $result = $c->writeConfig($filename, 'phparray', array('name' => $arrayName)); if (is_a($result, 'PEAR_Error')) { return $result; } return true; } } function getFileName($module, $langId, $path = SGL_MOD_DIR) { $fileName = $path . '/' . $module . '/lang/' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php'; return $fileName; } function getTranslations($module, $lang, $fallbackLang = false) { $c = &SGL_Config::singleton(); $conf = $c->getAll(); if (!empty($module) && !empty($lang)) { $lang = SGL_Translation::transformLangID($lang, SGL_LANG_ID_TRANS2); $installedLangs = explode(',', $conf['translation']['installedLanguages']); if ($conf['translation']['container'] == 'db' && in_array($lang, $installedLangs)) { $translation = &SGL_Translation::singleton(); $langInstalled = $translation->setLang($lang); $translation->setPageID($module); if ($fallbackLang) { $fallbackLang = (is_string($fallbackLang)) ? $fallbackLang : $conf['translation']['fallbackLang']; $translation = & $translation->getDecorator('Lang'); $translation->setOption('fallbackLang', $fallbackLang); } if ($conf['cache']['enabled']) { $translation = &$translation->getDecorator('CacheLiteFunction'); $translation->setOption('cacheDir', SGL_TMP_DIR .'/'); $translation->setOption('lifeTime', $conf['cache']['lifetime']); $translation->setOption('defaultGroup', 'translation'); } $words = ($words = $translation->getPage()) ? $words : array(); SGL::logMessage('translations from db for '. $module, PEAR_LOG_DEBUG); return $words; } elseif ($conf['translation']['container'] == 'file') { return SGL_Translation::getGuiTranslationsFromFile($module, $lang); } else { return array(); } } else { SGL::raiseError('Incorrect parameter passed to '.__CLASS__.'::'.__FUNCTION__, SGL_ERROR_INVALIDARGS); } } function getLangID($format = SGL_LANG_ID_TRANS2) { if (isset($_SESSION['aPrefs']['language'])) { $ret = $_SESSION['aPrefs']['language']; } else { $ret = SGL_Translation::getFallbackLangID(); } return SGL_Translation::transformLangID($ret, $format); } function getCharset($format = SGL_LANG_ID_SGL) { $lang = SGL_Translation::getLangID($format); return SGL_Translation::extractCharset($lang, $format); } function isAllowedLanguage($lang) { $lang = SGL_Translation::transformLangID($lang, SGL_LANG_ID_SGL); return isset($GLOBALS['_SGL']['LANGUAGE'][$lang]); } function extractCharset($lang, $format = SGL_LANG_ID_SGL) { switch ($format) { case SGL_LANG_ID_TRANS2: $devider = '_'; break; case SGL_LANG_ID_SGL: default: $devider = '-'; break; } $aLang = explode($devider, $lang); array_shift($aLang); if ($aLang[0] == 'tw') { array_shift($aLang); } return implode($devider, $aLang); } function getFallbackLangID($format = SGL_LANG_ID_TRANS2) { $lang = SGL_Config::get('translation.fallbackLang'); return SGL_Translation::transformLangID($lang, $format); } function getFallbackCharset($format = SGL_LANG_ID_SGL) { $lang = SGL_Translation::getFallbackLangID($format); return SGL_Translation::extractCharset($lang, $format); } function transformLangID($langID, $format = null) { if (isset($format)) { $langID = ($format == SGL_LANG_ID_SGL) ? str_replace('_', '-', $langID) : str_replace('-', '_', $langID); return $langID; } else { $langID = (strstr($langID, '-')) ? str_replace('-', '_', $langID) : str_replace('_', '-', $langID); return $langID; } } function removeTranslations($moduleName) { $trans = &SGL_Translation::singleton('admin'); $aPages = $trans->getPageNames(); if (PEAR::isError($aPages)) { return $aPages; } if (!in_array($moduleName, $aPages)) { return false; } $aLangs = $trans->getLangs('ids'); if (PEAR::isError($aLangs)) { return $aLangs; } $aStrings = array(); foreach ($aLangs as $langId) { $ret = SGL_Translation::getTranslations($moduleName, $langId); $aStrings = array_merge($aStrings, array_keys($ret)); } foreach ($aStrings as $stringId) { $ret = $trans->remove($stringId, $moduleName); if (PEAR::isError($ret)) { return $ret; } } return true; } function updateMetaData($aConfigs) { $aMetaData = array( '__SGL_UPDATED_BY' => SGL_Session::getUsername(), '__SGL_LAST_UPDATED' => SGL_Date::getTime() ); foreach ($aMetaData as $k => $v) { if (isset($aConfigs[$k])) { unset($aConfigs[$k]); } } $aRet = $aMetaData + $aConfigs; return $aRet; } function removeMetaData($aConfigs) { foreach ($aConfigs as $k => $v) { if (strpos($k, '__SGL_') === 0) { unset($aConfigs[$k]); } } return $aConfigs; } function lockTranslationFile($moduleName, $lang) { $fileName = $moduleName . '_' . $lang . '.lock.txt'; $targetDir = SGL_VAR_DIR . '/translation'; $ok = SGL_Translation::ensureDirIsWrirable($targetDir); if (PEAR::isError($ok)) { return $ok; } $ok = touch($targetDir . '/' . $fileName); if ($ok === false) { return SGL::raiseError(__CLASS__ . ': error creating transation ' . 'locking file', SGL_ERROR_INVALIDFILEPERMS); } file_put_contents($targetDir . '/' . $fileName, SGL_Session::getUsername()); } function translationFileIsLocked($moduleName, $lang) { $ret = false; $fileName = SGL_VAR_DIR . "/translation/{$moduleName}_{$lang}.lock.txt"; if (file_exists($fileName)) { $period = time() - filemtime($fileName); if ($period < 15 * 60) { $currentUser = file_get_contents($fileName); if ($currentUser != SGL_Session::getUsername()) { $ret = true; } } else { SGL_Translation::removeTranslationLock($moduleName, $lang); } } return $ret; } function removeTranslationLock($moduleName, $lang) { $fileName = SGL_VAR_DIR . "/translation/{$moduleName}_{$lang}.lock.txt"; if (file_exists($fileName)) { $ok = unlink($fileName); if ($ok === false) { return SGL::raiseError(__CLASS__ . ': error removing transation ' . 'locking file', SGL_ERROR_INVALIDFILEPERMS); } } } function removeTranslationLocksByUser($username) { $targetDir = SGL_VAR_DIR . '/translation'; if (file_exists($targetDir) && is_readable($targetDir)) { $dh = opendir($targetDir); while (($fileName = readdir($dh)) !== false) { if ($fileName == '..' || $fileName == '.') { continue; } $configFile = $targetDir . '/' . $fileName; $lockedUser = file_get_contents($configFile); if ($lockedUser == $username) { $ok = unlink($configFile); if ($ok === false) { return SGL::raiseError(__CLASS__ . ': error removing ' . 'transation locking file', SGL_ERROR_INVALIDFILEPERMS); } } } closedir($dh); } } function ensureDirIsWrirable($dirName) { if (!is_writable($dirName)) { require_once 'System.php'; $ok = System::mkDir(array('-p', $dirName)); if (PEAR::isError($ok)) { return $ok; } if (!$ok) { return SGL::raiseError("Error making directory
                    '$dirName' writable"); } $mask = umask(0); $ok = @chmod($dirName, 0777); if (!$ok) { return SGL::raiseError("Error performing chmod on
                    directory '$dirName'"); } umask($mask); } return true; } function escapeSingleQuote($string) { $ret = str_replace('\\', '\\\\', $string); $ret = str_replace("'", '\\\'', $ret); return $ret; } function escapeSingleQuoteInArrayKeys($array) { $ret = array(); foreach ($array as $key => $value) { $k = SGL_Translation::escapeSingleQuote($key); $ret[$k] = is_array($value) ? SGL_Translation::escapeSingleQuoteInArrayKeys($value) : $value; } return $ret; } } ?><?php
 $GLOBALS['_SGL']['LANGUAGE'] = (SGL::isMinimalInstall()) ? array('en-iso-8859-15'=> array('en([-_][[:alpha:]]{2})?|english', 'english-iso-8859-15', 'en')) : array( 'af-iso-8859-1'=> array('af','afrikaans-iso-8859-1','af', 'af_ZA.iso88591','afrikaans'), 'sq-iso-8859-1'=> array('sq','albanian-iso-8859-1','sq', 'sq_AL.iso88591','albanian'), 'ar-windows-1256'=> array('ar','arabic-windows-1256','ar', 'ar_AE.iso88596','arabic'), 'az-iso-8859-9'=> array('az','azerbaijani-iso-8859-9','az', 'az_AZ.utf8' , 'azerbaijani'), 'eu-iso-8859-1'=> array('eu','basque-iso-8859-1','eu', 'eu_ES.iso88591' , 'basque'), 'becyr-windows-1251'=> array('becyr','belarusian-windows-1251','becyr', 'be_BY' , 'belarusian'), 'bs-windows-1250'=> array('bs','bosnian-windows-1250','bs', 'bs_BA.iso88592' , 'bosnian'), 'bg-windows-1251'=> array('bg','bulgarian-windows-1251','bg', 'bg_BG.cp1251' , 'bulgarian'), 'ca-iso-8859-1'=> array('ca','catalan-iso-8859-1','ca', 'ca_ES.iso88591' , 'catalan'), 'hr-windows-1250'=> array('hr','croatian-windows-1250','hr', 'hr_HR.iso88592' , 'croatian'), 'da-iso-8859-1'=> array('da','danish-iso-8859-1','da', 'da_DK.iso88591' , 'danish'), 'nl-iso-8859-1'=> array('nl','dutch-iso-8859-1','nl', 'nl_NL.iso88591' , 'dutch'), 'et-iso-8859-1'=> array('et','estonian-iso-8859-1','et', 'et_EE.iso88591' , 'estonian'), 'fi-iso-8859-1'=> array('fi','finnish-iso-8859-1','fi', 'fi_FI.iso88591' , 'finnish'), 'gl-iso-8859-1'=> array('gl','galician-iso-8859-1','gl', 'gl_ES.iso88591', 'galician'), 'el-iso-8859-7'=> array('el','greek-iso-8859-7','el', 'el_GR.iso88597', 'greek'), 'he-iso-8859-8'=> array('he','hebrew-iso-8859-8','he', 'he_IL.iso88598', 'hebrew'), 'hu-iso-8859-2'=> array('hu','hungarian-iso-8859-2','hu', 'hu_HU.iso88592', 'hungarian'), 'id-iso-8859-1'=> array('id','indonesian-iso-8859-1','id', 'id_ID.iso88591', 'hungarian'), 'ja-shift_jis'=> array('ja','japanese-shift_jis','ja', 'ja_JP.ujis', 'japanese'), 'ko-euc-kr'=> array('ko','korean-euc-kr','ko', 'ko_KR.euckr', 'korean'), 'lv-windows-1257'=> array('lv','latvian-windows-1257','lv', 'lv_LV.iso885913', 'latvian'), 'lt-windows-1257'=> array('lt','lithuanian-windows-1257','lt', 'lt_LT.iso885913', 'lithuanian'), 'fa-windows-1256'=> array('fa','persian-windows-1256','fa', 'fa_IR', 'persian'), 'ro-iso-8859-1'=> array('ro','romanian-iso-8859-1','ro', 'ro_RO.iso88592', 'romanian'), 'srcyr-windows-1251'=> array('srcyr','serbian-windows-1251','srcyr', 'sr_YU', 'serbian'), 'srcyr-windows-1250'=> array('srcyr','serbian-latin-windows-1250','srcyr','sh_SP', 'serbian latin'), 'sk-windows-1250'=> array('sk','slovak-windows-1250','sk', 'sk_SK.iso88592', 'slovak'), 'sl-iso-8859-2'=> array('sl','slovenian-iso-8859-2','sl', 'sl_SI.iso88592', 'slovenian'), 'sv-iso-8859-1'=> array('sv','swedish-iso-8859-1','sv', 'sv_FI.iso88591', 'swedish'), 'tt-iso-8859-9'=> array('tt','tatarish-iso-8859-9','tt', 'tt_RU.utf8', 'tatarish'), 'uk-windows-1251'=> array('uk','ukrainian-windows-1251','uk', 'uk_UA', 'ukrainian'), 'en-iso-8859-15'=> array('en([-_][[:alpha:]]{2})?|english', 'english-iso-8859-15', 'en'), 'en-utf-8'=> array('en([-_][[:alpha:]]{2})?|english', 'english-utf-8', 'en', 'en_US.utf8'), 'th-utf-8'=> array('th|thai', 'thai-utf-8', 'th', 'th_TH.utf8'), 'es-iso-8859-1'=> array('es([-_][[:alpha:]]{2})?|spanish', 'spanish-iso-8859-1', 'es'), 'es-utf-8'=> array('es([-_][[:alpha:]]{2})?|spanish', 'spanish-utf-8', 'es'), 'fr-iso-8859-1'=> array('fr([-_][[:alpha:]]{2})?|french', 'french-iso-8859-1', 'fr'), 'fr-utf-8' => array('fr([-_][[:alpha:]]{2})?|french', 'french-utf-8', 'fr'), 'it-iso-8859-1'=> array('it|italian', 'italian-iso-8859-1', 'it'), 'ja-euc-jp' => array('ja|japanese', 'japanese-euc-jp', 'ja'), 'ja-utf-8' => array('ja|japanese', 'japanese-utf-8', 'ja'), 'no-iso-8859-1'=> array('no|norwegian', 'norwegian-iso-8859-1', 'no'), 'ptbr-iso-8859-1' => array('pt[-_]br|brazilian portuguese', 'brazilian_portuguese-iso-8859-1', 'pt-BR'), 'pt-iso-8859-1'=> array('pt([-_][[:alpha:]]{2})?|portuguese', 'portuguese-iso-8859-1', 'pt'), 'pl-iso-8859-2'=> array('pl|polish', 'polish-iso-8859-2', 'pl'), 'ru-windows-1251' => array('ru|russian', 'russian-windows-1251', 'ru'), 'ru-utf-8' => array('ru|russian', 'russian-utf-8', 'ru'), 'tr-iso-8859-9'=> array('tr|turkish', 'turkish-iso-8859-9', 'tr'), 'tr-utf-8' => array('tr|turkish', 'turkish-utf-8', 'tr'), 'zhtw-utf-8' => array('zh[-_](tw|hk)|chinese traditional', 'chinese_traditional-utf-8', 'zh-TW'), 'zhtw-big5' => array('zh[-_](tw|hk)|chinese traditional', 'chinese-big5', 'zh-TW'), 'zh-utf-8' => array('zh|chinese simplified', 'chinese_simplified-utf-8', 'zh'), 'zh-gb2312' => array('zh|chinese simplified', 'chinese-gb2312', 'zh'), 'de-iso-8859-1'=> array('de([-_][[:alpha:]]{2})?|german', 'german-iso-8859-1', 'de', 'de_DE', 'german'), 'th-tis-620'=> array('th|thai', 'th-tis-620', 'th', 'th_TH.tis620', 'thai'), 'ms-iso-8859-1'=> array('ms|malaysian', 'malaysian-iso-8859-1', 'ms', 'ms_MY.iso88591', 'malaysian'), 'pt-br-iso-8859-1' => array('pt[-_]br|brazilian portuguese', 'brazilian_portuguese-iso-8859-1', 'pt-BR','pt_BR.iso88591', 'brazilian portuguese'), 'cs-windows-1250'=> array('cs','czech-windows-1250','cs', 'cs_CZ.iso88592', 'czech'), 'zh-big5'=> array('zh','chinese-big5','zh', 'zh_TW.big5', 'traditional chinese'), ); function SGL_cmp(&$a, $b) { return (strcmp($a[1], $b[1])); } ?>
